/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.types;

import java.time.ZoneId;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import net.intelie.pipes.time.Period;
import net.intelie.pipes.time.TimeSpan;
import net.intelie.pipes.types.WindowInfo;
import net.intelie.pipes.types.WindowSpan;

public class KeepOutputInfo
implements WindowInfo {
    private static final long serialVersionUID = 1L;
    private final long ttl;
    private final Period output;

    public KeepOutputInfo(long ttl, Period output) {
        this.ttl = ttl;
        this.output = output;
    }

    @Override
    public WindowSpan wrap(final TimeSpan span) {
        return new WindowSpan(span, this){
            private static final long serialVersionUID = 1L;

            @Override
            public long windowStart(long reference) {
                if (KeepOutputInfo.this.ttl == Long.MAX_VALUE) {
                    return reference;
                }
                reference = KeepOutputInfo.this.output.floor(reference);
                for (long i = 0L; i < KeepOutputInfo.this.ttl; ++i) {
                    reference = KeepOutputInfo.this.output.sub(reference);
                }
                return reference;
            }

            @Override
            public WindowSpan forceZone(ZoneId zone) {
                return KeepOutputInfo.this.wrap(span.forceZone(zone));
            }

            @Override
            public boolean isPoint() {
                return span.isPoint() && (KeepOutputInfo.this.ttl == Long.MAX_VALUE || KeepOutputInfo.this.ttl == 0L);
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KeepOutputInfo)) {
            return false;
        }
        KeepOutputInfo that = (KeepOutputInfo)o;
        return Objects.equals(this.output, that.output) && Objects.equals(this.ttl, that.ttl);
    }

    public int hashCode() {
        return Objects.hash(this.output, this.ttl);
    }

    public String toString() {
        if (this.ttl == Long.MAX_VALUE) {
            return "";
        }
        return "keep(" + this.ttl + ") every " + this.output;
    }

    @Override
    public Iterator<WindowInfo> iterator() {
        if (this.ttl == Long.MAX_VALUE) {
            return Collections.emptyIterator();
        }
        return Collections.singleton(this).iterator();
    }
}

