/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.types;

import java.io.Serializable;
import java.util.Objects;
import net.intelie.pipes.Aggregation;
import net.intelie.pipes.Expression;
import net.intelie.pipes.Scalar;
import net.intelie.pipes.types.Type;

public abstract class Level
implements Serializable {
    public static final ExpressionLevel EXPRESSION = new ExpressionLevel(0).withClosure(0);
    public static final AggregationLevel AGGREGATION = new AggregationLevel(0).withClosure(0);
    public static final ScalarLevel SCALAR = new ScalarLevel(0).withClosure(0);
    public static final ConstantLevel CONSTANT = new ConstantLevel(0).withClosure(0);
    private static final long serialVersionUID = 1L;
    private final int index;
    private final Class<? extends Expression> javaClass;
    private final String name;
    private int closure;

    private Level(int index, int closure, Class<? extends Expression> javaClass, String name) {
        this.index = index;
        this.closure = closure;
        this.javaClass = javaClass;
        this.name = name;
    }

    public static Level min(Expression ... exprs) {
        Level result = CONSTANT;
        for (Expression expr : exprs) {
            result = Level.minTwo(result, expr.level());
        }
        return result;
    }

    public static Level min(Level ... levels) {
        Level result = CONSTANT;
        for (Level level : levels) {
            result = Level.minTwo(result, level);
        }
        return result;
    }

    private static Level minTwo(Level a, Level b) {
        Level minLevel = a.index < b.index ? a : b;
        return minLevel.withClosure(Math.max(a.closure, b.closure));
    }

    public static <T> Aggregation<T> asAggregation(Expression<T> expr) {
        return (Aggregation)expr;
    }

    public static <T> Scalar<T> asScalar(Expression<T> expr) {
        return (Scalar)expr;
    }

    public abstract Level withClosure(int var1);

    public Level withMaxClosure() {
        return this.withClosure(Integer.MAX_VALUE);
    }

    public Level increaseClosure(int units) {
        units = Math.min(units, Integer.MAX_VALUE - this.closure);
        return this.withClosure(this.closure + units);
    }

    public Class<? extends Expression> javaClass() {
        return this.javaClass;
    }

    public int closure() {
        return this.closure;
    }

    public String name() {
        return this.name;
    }

    public boolean isAssignableTo(Level level) {
        return level != null && this.index >= level.index;
    }

    public boolean accepts(Object expr) {
        return this.javaClass.isInstance(expr) && this.javaClass.cast(expr).level().isAssignableTo(this);
    }

    public int hashCode() {
        return Objects.hash(this.index, this.closure);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Level)) {
            return false;
        }
        Level level = (Level)o;
        return Objects.equals(this.index, level.index) && Objects.equals(this.closure, level.closure);
    }

    public abstract <T> Token<T, ? extends Expression<T>> token(Type<T> var1);

    public String toString() {
        return this.name + (this.closure > 0 ? " (" + (this.closure < Integer.MAX_VALUE ? Integer.valueOf(this.closure) : "max") + ")" : "");
    }

    public class Token<T, Q extends Expression<T>> {
        private final Type<T> type;
        private final Level level;

        public Token(Type<T> type, Level level) {
            this.type = type;
            this.level = level;
        }

        public Type<T> type() {
            return this.type;
        }

        public Class<Q> javaClass() {
            return this.level.javaClass();
        }

        public Level level() {
            return this.level;
        }

        public boolean acceptsType(Expression expr) {
            return this.type.accepts(expr);
        }

        public boolean acceptsLevel(Expression expr) {
            return this.level.accepts(expr);
        }
    }

    public static class ConstantLevel
    extends Level {
        private static final long serialVersionUID = 1L;

        private ConstantLevel(int closure) {
            super(4, closure, Scalar.class, "a constant");
        }

        @Override
        public ConstantLevel withClosure(int depth) {
            return new ConstantLevel(depth);
        }

        public <T> Token<T, Scalar<T>> token(Type<T> type) {
            return new Token(type, this);
        }
    }

    public static class ScalarLevel
    extends Level {
        private static final long serialVersionUID = 1L;

        private ScalarLevel(int closure) {
            super(2, closure, Scalar.class, "a scalar");
        }

        @Override
        public ScalarLevel withClosure(int depth) {
            return new ScalarLevel(depth);
        }

        public <T> Token<T, Scalar<T>> token(Type<T> type) {
            return new Token(type, this);
        }
    }

    public static class AggregationLevel
    extends Level {
        private static final long serialVersionUID = 1L;

        private AggregationLevel(int closure) {
            super(1, closure, Aggregation.class, "an aggregation");
        }

        @Override
        public AggregationLevel withClosure(int depth) {
            return new AggregationLevel(depth);
        }

        public <T> Token<T, Aggregation<T>> token(Type<T> type) {
            return new Token(type, this);
        }
    }

    public static class ExpressionLevel
    extends Level {
        private static final long serialVersionUID = 1L;

        private ExpressionLevel(int level) {
            super(0, level, Expression.class, "an expression");
        }

        @Override
        public ExpressionLevel withClosure(int depth) {
            return new ExpressionLevel(depth);
        }

        public <T> Token<T, Expression<T>> token(Type<T> type) {
            return new Token(type, this);
        }
    }
}

