/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.types;

import java.util.Objects;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.types.MapType;
import net.intelie.pipes.types.ResolverState;
import net.intelie.pipes.types.Type;
import net.intelie.pipes.types.TypeResolver;

public class MapTypeResolver
implements TypeResolver {
    private static final long serialVersionUID = 1L;
    private final TypeResolver key;
    private final TypeResolver value;

    public MapTypeResolver(TypeResolver key, TypeResolver value) {
        this.key = key;
        this.value = value;
    }

    @Override
    public Type resolve(ResolverState state) throws PipeException {
        return new MapType(this.key.resolve(state), this.value.resolve(state));
    }

    @Override
    public void update(Type found, ResolverState state) throws PipeException {
        Type keyType = MapType.getKeyType(found);
        Type valueType = MapType.getValueType(found);
        if (keyType == null || valueType == null) {
            throw new PipeException("Expected a map. Found: %s.", found);
        }
        this.key.update(keyType, state);
        this.value.update(valueType, state);
    }

    public TypeResolver key() {
        return this.key;
    }

    public TypeResolver value() {
        return this.value;
    }

    @Override
    public TypeResolver removeWildcards(ResolverState state) {
        return new MapTypeResolver(this.key.removeWildcards(state), this.value.removeWildcards(state));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapTypeResolver that = (MapTypeResolver)o;
        return Objects.equals(this.key, that.key) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.value);
    }

    public String toString() {
        return "map(" + this.key + ", " + this.value + ")";
    }
}

