/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.types;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.intelie.pipes.types.ItemOutput;
import net.intelie.pipes.types.Output;
import net.intelie.pipes.types.RowFields;
import net.intelie.pipes.types.RowType;
import net.intelie.pipes.types.Type;
import net.intelie.pipes.types.WindowInfo;

public class Metadata
implements Serializable {
    public static final Metadata RAW = new Metadata((Type)Type.OBJECT, false, 0L, WindowInfo.NONE, Collections.singletonList(new ItemOutput(1)), Collections.emptyMap());
    private static final long serialVersionUID = 1L;
    private final Type type;
    private final Set<Output> output;
    private final long weight;
    private final boolean safe;
    private final WindowInfo window;
    private final Map<String, Object> custom;

    @Deprecated
    public Metadata(Type type) {
        this(type, false, 0L, WindowInfo.NONE, Arrays.asList(new ItemOutput(1)), Collections.emptyMap());
    }

    @Deprecated
    public Metadata(Type type, boolean safe, long weight, WindowInfo window, Output ... output) {
        this(type, safe, weight, window, Arrays.asList(output), Collections.emptyMap());
    }

    @Deprecated
    public Metadata(Type type, boolean safe, long weight, WindowInfo window, Iterable<Output> output) {
        this(type, safe, weight, window, output, Collections.emptyMap());
    }

    private Metadata(Type type, boolean safe, long weight, WindowInfo window, Iterable<Output> output, Map<String, Object> custom) {
        this.safe = safe;
        this.type = type;
        this.output = Collections.unmodifiableSet(this.makeSet(output));
        this.weight = weight;
        this.window = window;
        this.custom = Collections.unmodifiableMap(custom);
    }

    private LinkedHashSet<Output> makeSet(Iterable<Output> output) {
        return StreamSupport.stream(output.spliterator(), false).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public boolean isOutputCompatibleWith(Metadata other) {
        return Objects.equals(this.output, other.output);
    }

    public Type type() {
        return this.type;
    }

    public WindowInfo window() {
        return this.window;
    }

    public Set<Output> output() {
        return this.output;
    }

    public long weight() {
        return this.weight;
    }

    public boolean safe() {
        return this.safe;
    }

    public Map<String, Object> custom() {
        return this.custom;
    }

    public boolean hasRowFields() {
        return RowType.hasFields(this.type);
    }

    public RowFields getRowFields() {
        return RowType.getFields(this.type);
    }

    public Metadata resetWeights() {
        return this.resetWeights(0L);
    }

    public Metadata resetWeights(long weight) {
        return this.withWindow(WindowInfo.NONE).withWeight(weight);
    }

    public Metadata withSafe(boolean safe) {
        return new Metadata(this.type, safe, this.weight, this.window, this.output, this.custom);
    }

    public Metadata withOutput(Output ... output) {
        return this.withOutput(Arrays.asList(output));
    }

    public Metadata withWeight(long weight) {
        return new Metadata(this.type, this.safe, weight, this.window, this.output, this.custom);
    }

    public Metadata withOutput(Iterable<Output> output) {
        return new Metadata(this.type, this.safe, this.weight, this.window, output, this.custom);
    }

    public Metadata withWindow(WindowInfo window) {
        return new Metadata(this.type, this.safe, this.weight, window, this.output, this.custom);
    }

    public Metadata withType(Type type) {
        return new Metadata(type, this.safe, this.weight, this.window, this.output, this.custom);
    }

    public Metadata withCustom(Map<String, Object> custom) {
        return new Metadata(this.type, this.safe, this.weight, this.window, this.output, custom);
    }

    public Map<String, Object> simple() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(this.custom);
        map.put("type", this.type.toString());
        map.put("output", this.simpleOutput());
        map.put("safe", this.safe);
        map.put("weight", this.weight);
        map.put("window", this.window.toString());
        return map;
    }

    private List<Map<String, Object>> simpleOutput() {
        ArrayList<Map<String, Object>> outputSimple = new ArrayList<Map<String, Object>>(this.output.size());
        for (Output outputItem : this.output) {
            outputSimple.add(outputItem.simple());
        }
        return outputSimple;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Metadata)) {
            return false;
        }
        Metadata that = (Metadata)o;
        return Objects.equals(this.type, that.type) && Objects.equals(this.output, that.output) && Objects.equals(this.safe, that.safe) && Objects.equals(this.weight, that.weight) && Objects.equals(this.custom, that.custom) && Objects.equals(this.window, that.window);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.output, this.safe, this.weight, this.window, this.custom);
    }

    public String toString() {
        return "{" + this.type + ", " + this.output + ", safe=" + this.safe + ", weight=" + this.weight + ", window=[" + String.valueOf(this.window) + "], custom=" + this.custom + "}";
    }
}

