/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.types;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.types.ResolverState;
import net.intelie.pipes.types.Type;
import net.intelie.pipes.types.TypeResolver;
import net.intelie.pipes.util.Iterables;

public class MultiTypeResolver
implements TypeResolver {
    private static final long serialVersionUID = 1L;
    private final List<TypeResolver> resolvers;

    public MultiTypeResolver(List<TypeResolver> resolvers) {
        this.resolvers = Collections.unmodifiableList(resolvers);
    }

    @Override
    public Type resolve(ResolverState state) throws PipeException {
        Type type = Type.NULL;
        for (TypeResolver resolver : this.resolvers) {
            Type resolved = resolver.resolve(state);
            type = Type.min(type, resolved);
        }
        return type;
    }

    public List<TypeResolver> resolvers() {
        return this.resolvers;
    }

    @Override
    public void update(Type found, ResolverState state) throws PipeException {
        for (TypeResolver resolver : this.resolvers) {
            resolver.update(found, state);
        }
    }

    @Override
    public TypeResolver removeWildcards(ResolverState state) {
        return new MultiTypeResolver(this.resolvers.stream().map(x -> x.removeWildcards(state)).collect(Collectors.toList()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiTypeResolver that = (MultiTypeResolver)o;
        return Objects.equals(new HashSet<TypeResolver>(this.resolvers), new HashSet<TypeResolver>(that.resolvers));
    }

    public int hashCode() {
        return Objects.hash(this.resolvers);
    }

    public String toString() {
        return Iterables.join(" & ", this.resolvers);
    }
}

