/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.types;

import java.time.ZoneId;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import net.intelie.pipes.time.Period;
import net.intelie.pipes.time.TimeSpan;
import net.intelie.pipes.types.WindowInfo;
import net.intelie.pipes.types.WindowSpan;

public class OverLastInfo
implements WindowInfo {
    private static final long serialVersionUID = 1L;
    private final Period window;
    private final Period output;

    public OverLastInfo(Period window) {
        this(window, null);
    }

    public OverLastInfo(Period window, Period output) {
        this.window = window;
        this.output = output;
    }

    @Override
    public WindowSpan wrap(final TimeSpan span) {
        return new WindowSpan(span, this){
            private static final long serialVersionUID = 1L;

            @Override
            public long windowStart(long reference) {
                if (OverLastInfo.this.output != null) {
                    reference = OverLastInfo.this.output.floor(reference);
                }
                return OverLastInfo.this.window.sub(reference);
            }

            @Override
            public WindowSpan forceZone(ZoneId zone) {
                return OverLastInfo.this.wrap(span.forceZone(zone));
            }

            @Override
            public boolean isPoint() {
                return false;
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OverLastInfo)) {
            return false;
        }
        OverLastInfo that = (OverLastInfo)o;
        return Objects.equals(this.window, that.window) && Objects.equals(this.output, that.output);
    }

    public int hashCode() {
        return Objects.hash(this.window, this.output);
    }

    public String toString() {
        return "over last " + this.window + (this.output != null ? " every " + this.output : "");
    }

    @Override
    public Iterator<WindowInfo> iterator() {
        return Collections.singleton(this).iterator();
    }
}

