/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.types;

import java.time.ZoneId;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import net.intelie.pipes.time.Period;
import net.intelie.pipes.time.TimeSpan;
import net.intelie.pipes.types.WindowInfo;
import net.intelie.pipes.types.WindowSpan;

public class OverSpanInfo
implements WindowInfo {
    private static final long serialVersionUID = 1L;
    private final TimeSpan window;
    private final Period output;

    public OverSpanInfo(TimeSpan window) {
        this(window, null);
    }

    public OverSpanInfo(TimeSpan window, Period output) {
        this.window = window;
        this.output = output;
    }

    @Override
    public WindowSpan wrap(final TimeSpan span) {
        return new WindowSpan(span, this){
            private static final long serialVersionUID = 1L;

            @Override
            public long windowStart(long reference) {
                if (OverSpanInfo.this.output != null) {
                    reference = OverSpanInfo.this.output.floor(reference);
                }
                return OverSpanInfo.this.window.start(reference);
            }

            @Override
            public WindowSpan forceZone(ZoneId zone) {
                return OverSpanInfo.this.wrap(span.forceZone(zone));
            }

            @Override
            public boolean isPoint() {
                return false;
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OverSpanInfo)) {
            return false;
        }
        OverSpanInfo that = (OverSpanInfo)o;
        return Objects.equals(this.window, that.window) && Objects.equals(this.output, that.output);
    }

    public int hashCode() {
        return Objects.hash(this.window, this.output);
    }

    public String toString() {
        return "over '" + this.window + "'" + (this.output != null ? " every " + this.output : "");
    }

    @Override
    public Iterator<WindowInfo> iterator() {
        return Collections.singleton(this).iterator();
    }
}

