/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.types;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.types.ClauseInfo;
import net.intelie.pipes.types.FieldInfo;
import net.intelie.pipes.types.ResolverState;
import net.intelie.pipes.types.RowFields;
import net.intelie.pipes.types.RowType;
import net.intelie.pipes.types.Type;
import net.intelie.pipes.types.TypeResolver;
import net.intelie.pipes.util.Iterables;

public class RowTypeResolver
implements TypeResolver {
    private static final long serialVersionUID = 1L;
    private final FieldList fields;

    public RowTypeResolver(FieldList fields) {
        this.fields = fields;
    }

    @Override
    public Type resolve(ResolverState state) throws PipeException {
        if (this.fields == null) {
            return new RowType(null);
        }
        return new RowType(this.fields.resolve(state));
    }

    @Override
    public void update(Type found, ResolverState state) throws PipeException {
        if (!found.isAssignableTo(Type.ROW)) {
            throw new PipeException("Expected a row. Found: %s.", found);
        }
        RowFields foundFields = RowType.getFields(found);
        if (this.fields != null && foundFields == null) {
            throw new PipeException("Expected row fields: '%s'. Found none.", this.fields, found);
        }
        if (this.fields != null) {
            this.fields.update(foundFields, state);
        }
    }

    public FieldList fields() {
        return this.fields;
    }

    @Override
    public TypeResolver removeWildcards(ResolverState state) {
        if (this.fields == null) {
            return this;
        }
        FieldList fields = this.fields.removeWildcards(state);
        return new RowTypeResolver(fields);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RowTypeResolver that = (RowTypeResolver)o;
        return Objects.equals(this.fields, that.fields);
    }

    public int hashCode() {
        return Objects.hash(this.fields);
    }

    public String toString() {
        if (this.fields == null) {
            return "row(?)";
        }
        return "row(" + this.fields + ")";
    }

    public static class FieldList
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final List<Field> timestamp;
        private final List<Field> group;
        private final List<Field> select;

        public FieldList(List<Field> timestamp, List<Field> group, List<Field> select) {
            this.timestamp = Collections.unmodifiableList(timestamp);
            this.group = Collections.unmodifiableList(group);
            this.select = Collections.unmodifiableList(select);
        }

        public RowFields resolve(ResolverState state) throws PipeException {
            return new RowFields(this.resolveClause(this.timestamp, state), this.resolveClause(this.group, state), this.resolveClause(this.select, state));
        }

        public List<Field> timestamp() {
            return this.timestamp;
        }

        public List<Field> group() {
            return this.group;
        }

        public List<Field> select() {
            return this.select;
        }

        public Field get(int index) {
            int ori = index;
            if (index < this.timestamp.size()) {
                return this.timestamp.get(index);
            }
            if ((index -= this.timestamp.size()) < this.group.size()) {
                return this.group.get(index);
            }
            if ((index -= this.group.size()) < this.select.size()) {
                return this.select.get(index);
            }
            throw new ArrayIndexOutOfBoundsException(ori);
        }

        public int size() {
            return this.timestamp.size() + this.group.size() + this.select.size();
        }

        private ClauseInfo resolveClause(List<Field> fields, ResolverState state) throws PipeException {
            ArrayList<FieldInfo> timestamp = new ArrayList<FieldInfo>();
            for (Field field : fields) {
                timestamp.add(field.resolve(state));
            }
            return new ClauseInfo(timestamp);
        }

        public void update(RowFields found, ResolverState state) throws PipeException {
            int expectedSize = this.timestamp.size() + this.group.size() + this.select.size();
            if (found.size() != expectedSize) {
                throw new PipeException("Expected row fields size: %s. Found: %s.", expectedSize, found.size());
            }
            Iterator<FieldInfo> it = found.iterator();
            FieldList.alignClause(this.timestamp, it, state);
            FieldList.alignClause(this.group, it, state);
            FieldList.alignClause(this.select, it, state);
        }

        private static void alignClause(List<Field> clause, Iterator<FieldInfo> fields, ResolverState state) throws PipeException {
            for (Field field : clause) {
                field.update(fields.next(), state);
            }
        }

        public FieldList removeWildcards(ResolverState state) {
            return new FieldList(this.timestamp.stream().map(x -> x.removeWildcards(state)).collect(Collectors.toList()), this.group.stream().map(x -> x.removeWildcards(state)).collect(Collectors.toList()), this.select.stream().map(x -> x.removeWildcards(state)).collect(Collectors.toList()));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FieldList fieldList = (FieldList)o;
            return Objects.equals(this.timestamp, fieldList.timestamp) && Objects.equals(this.group, fieldList.group) && Objects.equals(this.select, fieldList.select);
        }

        public int hashCode() {
            return Objects.hash(this.timestamp, this.group, this.select);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            if (this.timestamp.size() > 0) {
                builder.append(Iterables.join(", ", this.timestamp)).append("; ");
            }
            if (this.group.size() > 0) {
                builder.append(Iterables.join(", ", this.group)).append("; ");
            }
            return builder.append(Iterables.join(", ", this.select)).toString();
        }
    }

    public static class Field
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String name;
        private final TypeResolver type;

        public Field(String name, TypeResolver type) {
            this.name = name;
            this.type = type;
        }

        public FieldInfo resolve(ResolverState state) throws PipeException {
            return new FieldInfo(this.makeName(), this.type.resolve(state));
        }

        private String makeName() {
            return this.name != null ? this.name : "_";
        }

        public String name() {
            return this.name;
        }

        public TypeResolver type() {
            return this.type;
        }

        public void update(FieldInfo found, ResolverState state) throws PipeException {
            this.type.update(found.type(), state);
        }

        public Field removeWildcards(ResolverState state) {
            return new Field(this.name, this.type.removeWildcards(state));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Field field = (Field)o;
            return Objects.equals(this.name, field.name) && Objects.equals(this.type, field.type);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.type);
        }

        public String toString() {
            return this.type + (this.name != null ? " " + this.name : "");
        }
    }
}

