/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.types;

import java.util.Objects;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.types.ResolverState;
import net.intelie.pipes.types.SeqType;
import net.intelie.pipes.types.Type;
import net.intelie.pipes.types.TypeResolver;

public class SeqTypeResolver
implements TypeResolver {
    private static final long serialVersionUID = 1L;
    private final TypeResolver type;

    public SeqTypeResolver(TypeResolver type) {
        this.type = type;
    }

    public TypeResolver type() {
        return this.type;
    }

    @Override
    public Type resolve(ResolverState state) throws PipeException {
        return new SeqType(this.type.resolve(state));
    }

    @Override
    public void update(Type found, ResolverState state) throws PipeException {
        Type innerType = SeqType.getInnerType(found);
        if (innerType == null) {
            throw new PipeException("Expected a seq. Found: %s.", found);
        }
        this.type.update(innerType, state);
    }

    @Override
    public TypeResolver removeWildcards(ResolverState state) {
        return new SeqTypeResolver(this.type.removeWildcards(state));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SeqTypeResolver that = (SeqTypeResolver)o;
        return Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.type);
    }

    public String toString() {
        return "seq(" + this.type + ")";
    }
}

