/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.types;

import java.util.Collections;
import java.util.List;
import net.intelie.pipes.types.BinaryIterator;
import net.intelie.pipes.types.Type;
import net.intelie.pipes.util.DoubleUtils;

public final class StringType
extends Type<String> {
    private static final long serialVersionUID = 1L;

    public StringType() {
        super(String.class, "string");
    }

    @Override
    public final String cast(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Number) {
            return DoubleUtils.format(((Number)value).doubleValue());
        }
        return "" + value;
    }

    @Override
    public String makeString(Object operand) {
        return operand + "$";
    }

    @Override
    public List<Type> typeChain() {
        return Collections.singletonList(Type.COMPARABLE);
    }

    @Override
    public BinaryIterator newIterator() {
        return new StringIterator();
    }

    private static class StringIterator
    implements BinaryIterator {
        private String s;
        private int i;

        private StringIterator() {
        }

        @Override
        public boolean reset(Object value) {
            String str = Type.STRING.cast(value);
            if (str == null) {
                return false;
            }
            this.s = str;
            this.i = -1;
            return true;
        }

        @Override
        public void clear() {
            this.s = null;
        }

        @Override
        public boolean isLast() {
            return this.i + 1 >= this.s.length();
        }

        @Override
        public boolean moveNext() {
            return ++this.i < this.s.length();
        }

        @Override
        public int current() {
            return Character.toLowerCase(this.s.charAt(this.i));
        }
    }
}

