/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.types;

import java.util.Objects;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.types.DirectTypeResolver;
import net.intelie.pipes.types.ResolverState;
import net.intelie.pipes.types.Type;
import net.intelie.pipes.types.TypeResolver;

public class WildcardTypeResolver
implements TypeResolver {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final boolean exact;

    public WildcardTypeResolver(String name, boolean exact) {
        this.name = name;
        this.exact = exact;
    }

    @Override
    public Type resolve(ResolverState state) throws PipeException {
        if (state == null || state.get(this.name) == null) {
            throw new PipeException("Unresolvable type argument: %s.", this.toString());
        }
        return state.get(this.name);
    }

    @Override
    public void update(Type found, ResolverState state) throws PipeException {
        Type<?> expected = state.get(this.name);
        if (this.exact) {
            if (expected != null && !found.isAssignableTo(expected)) {
                throw new PipeException("Type argument: '%s'. Expected type: %s. Found: %s.", this.toString(), expected, found);
            }
            if (expected == null) {
                state.set(this.name, found);
            }
        } else {
            state.set(this.name, expected == null ? found : Type.min(expected, found));
        }
    }

    public String name() {
        return this.name;
    }

    public boolean exact() {
        return this.exact;
    }

    @Override
    public TypeResolver removeWildcards(ResolverState state) {
        Type<?> type = state.get(this.name);
        if (type == null) {
            return this;
        }
        return DirectTypeResolver.create(type);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WildcardTypeResolver that = (WildcardTypeResolver)o;
        return this.exact == that.exact && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.exact);
    }

    public String toString() {
        return (this.exact ? "!" : "$") + this.name;
    }
}

