/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.types;

import java.time.ZoneId;
import net.intelie.pipes.time.SpanMetadata;
import net.intelie.pipes.time.TimeSpan;
import net.intelie.pipes.time.TimeSpanBase;
import net.intelie.pipes.types.WindowInfo;

public abstract class WindowSpan
extends TimeSpanBase {
    private static final long serialVersionUID = 1L;
    private final TimeSpan span;

    public WindowSpan(TimeSpan span, WindowInfo window) {
        super(new SpanMetadata("<" + window + "> before $1", span));
        this.span = span;
    }

    @Override
    public long start(long reference) {
        if (this.span != null) {
            reference = this.span.start(reference);
        }
        return Math.min(reference, this.windowStart(reference));
    }

    @Override
    public abstract WindowSpan forceZone(ZoneId var1);

    public abstract long windowStart(long var1);

    @Override
    public long end(long reference) {
        return this.span.end(reference);
    }

    @Override
    public boolean isFixed() {
        return this.span.isFixed();
    }

    @Override
    public boolean includesPresent() {
        return this.span.includesPresent();
    }
}

