/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class AutomatonRepr {
    private final List<Node> nodes = new ArrayList<Node>();
    private final List<Edge> edges = new ArrayList<Edge>();
    private final Map<String, String> aliases = new HashMap<String, String>();
    private final Set<String> reserved = new HashSet<String>();
    private String startId;

    public AutomatonRepr(String startId) {
        this.startId = startId;
    }

    private static String prefixId(String prefix, AutomatonRepr to, String id) {
        return (to.reserved.contains(id) ? "" : prefix) + id;
    }

    public String getStartId() {
        return this.startId;
    }

    public void setStartId(String startId) {
        this.startId = startId;
    }

    public void addNode(String shape, String id, Object label) {
        this.nodes.add(new Node(shape, id, String.valueOf(label)));
    }

    public void addAlias(String alias, String to) {
        this.aliases.put(alias, to);
        this.addReserved(alias);
    }

    public void addReserved(String alias) {
        this.reserved.add(alias);
    }

    public void addEdge(String from, String to, Object label) {
        this.edges.add(new Edge(from, to, String.valueOf(label)));
    }

    public void addEdge(String from, String prefix, AutomatonRepr to, Object label) {
        this.merge(prefix, to);
        this.addEdge(from, AutomatonRepr.prefixId(prefix, to, to.startId), label);
    }

    public void merge(String prefix, AutomatonRepr repr) {
        for (Node node : repr.nodes) {
            this.addNode(node.shape, AutomatonRepr.prefixId(prefix, repr, node.id), node.label);
        }
        for (Edge edge : repr.edges) {
            this.addEdge(AutomatonRepr.prefixId(prefix, repr, edge.from), AutomatonRepr.prefixId(prefix, repr, edge.to), edge.label);
        }
        for (Map.Entry entry : repr.aliases.entrySet()) {
            this.addAlias((String)entry.getKey(), AutomatonRepr.prefixId(prefix, repr, (String)entry.getValue()));
        }
        this.reserved.addAll(repr.reserved);
    }

    public String toString(boolean tree) {
        StringBuilder builder = new StringBuilder();
        builder.append("digraph {\n").append(tree ? "  ordering=out\n" : "  rankdir=LR\n");
        LinkedHashMap<String, List> nodeShapes = new LinkedHashMap<String, List>();
        for (Node node : this.nodes) {
            List nodeList = nodeShapes.computeIfAbsent(node.shape, k -> new ArrayList());
            nodeList.add(node);
        }
        for (Map.Entry entry : nodeShapes.entrySet()) {
            builder.append(String.format((Locale)null, "  node[shape=%s];\n  ", entry.getKey()));
            for (Node node : (List)entry.getValue()) {
                builder.append(String.format((Locale)null, "%s[label=\"%s\"];", node.id, node.label));
            }
            builder.append("\n");
        }
        for (Edge edge : this.edges) {
            String from = edge.from;
            String to = edge.to;
            while (this.aliases.containsKey(from)) {
                from = this.aliases.get(from);
            }
            while (this.aliases.containsKey(to)) {
                to = this.aliases.get(to);
            }
            builder.append(String.format((Locale)null, "  %s -> %s [label=\"%s\"];\n", from, to, edge.label));
        }
        builder.append("}");
        return builder.toString();
    }

    public String toString() {
        return this.toString(false);
    }

    public static class Edge {
        private final String from;
        private final String to;
        private final String label;

        public Edge(String from, String to, String label) {
            this.from = from;
            this.to = to;
            this.label = label;
        }
    }

    public static class Node {
        private final String shape;
        private final String id;
        private final String label;

        public Node(String shape, String id, String label) {
            this.shape = shape;
            this.id = id;
            this.label = label;
        }
    }
}

