/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.util;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.intelie.pipes.Expression;
import net.intelie.pipes.Row;
import net.intelie.pipes.Scalar;
import net.intelie.pipes.types.Level;
import net.intelie.pipes.types.MapType;
import net.intelie.pipes.types.RowFields;
import net.intelie.pipes.types.RowType;
import net.intelie.pipes.types.SeqType;
import net.intelie.pipes.types.StringType;
import net.intelie.pipes.types.Type;
import net.intelie.pipes.util.Iterables;

public abstract class GetUtils {
    public static Type inferType(Type target, Expression ... exprs) {
        for (Expression expr : exprs) {
            target = GetUtils.inferSingle(target, expr);
        }
        return target;
    }

    private static Type inferSingle(Type target, Expression expr) {
        int index;
        RowType extractedRow;
        RowFields fields;
        if (target == null) {
            return null;
        }
        if (Level.CONSTANT.accepts(expr) && Type.extract(target, RowType.class) != null && (fields = (extractedRow = Type.extract(target, RowType.class)).fields()) != null && (index = fields.indexOf(Type.STRING.cast(((Scalar)expr).eval(null, null)))) >= 0) {
            return fields.type(index);
        }
        MapType extractedMap = Type.extract(target, MapType.class);
        if (extractedMap != null) {
            return extractedMap.valueType();
        }
        SeqType extractedSeq = Type.extract(target, SeqType.class);
        if (extractedSeq != null) {
            return extractedSeq.type();
        }
        if (Type.extract(target, StringType.class) != null) {
            return Type.STRING;
        }
        return null;
    }

    public static Double len(Object target) {
        try {
            if (target == null) {
                return null;
            }
            if (target instanceof String) {
                return ((String)target).length();
            }
            if (target instanceof Row) {
                return ((Row)target).size();
            }
            if (target instanceof Iterable) {
                return Iterables.size((Iterable)target);
            }
            if (target instanceof Map) {
                return ((Map)target).size();
            }
            if (target.getClass().isArray()) {
                return Array.getLength(target);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object get(Object target, Object ... args) {
        try {
            for (Object arg : args) {
                target = GetUtils.getSingle(target, arg);
            }
            return target;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object getSingle(Object target, Object arg) {
        if (target == null) {
            return null;
        }
        if (target instanceof Map) {
            return GetUtils.getFromMap((Map)target, arg);
        }
        if (arg instanceof Number) {
            return GetUtils.getWithNumericIndex(target, (Number)arg);
        }
        if (arg instanceof String) {
            try {
                return GetUtils.getWithNumericIndex(target, Double.parseDouble((String)arg));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static Object getWithNumericIndex(Object target, Number arg) {
        int index = arg.intValue();
        if (index < 0) {
            return null;
        }
        if (target instanceof String) {
            if (index >= ((String)target).length()) {
                return null;
            }
            return Character.toString(((String)target).charAt(index));
        }
        if (target instanceof Row) {
            if (index >= ((Row)target).size()) {
                return null;
            }
            return ((Row)target).get(index);
        }
        if (target instanceof Collection) {
            if (index >= ((Collection)target).size()) {
                return null;
            }
            if (target instanceof List) {
                return ((List)target).get(index);
            }
        }
        if (target instanceof Iterable) {
            return GetUtils.getFromIterable((Iterable)target, index);
        }
        if (target != null && (target instanceof Object[] || target.getClass().isArray())) {
            if (index >= Array.getLength(target)) {
                return null;
            }
            return Array.get(target, index);
        }
        return null;
    }

    private static Object getFromIterable(Iterable target, int index) {
        Iterator iterator = target.iterator();
        int skipped = 0;
        while (iterator.hasNext()) {
            Object value = iterator.next();
            if (skipped++ != index) continue;
            return value;
        }
        return null;
    }

    private static Object getFromMap(Map target, Object arg) {
        return target.get(arg);
    }
}

