/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.util;

import java.util.Locale;
import net.intelie.pipes.PipeException;

public abstract class Levenshtein {
    public static int distance(String a, String b) {
        int i;
        int[] A = new int[b.length() + 1];
        int[] B = new int[b.length() + 1];
        for (i = 0; i <= b.length(); ++i) {
            A[i] = i;
        }
        for (i = 1; i <= a.length(); ++i) {
            int[] T = B;
            B = A;
            A = T;
            A[0] = i;
            for (int j = 1; j <= b.length(); ++j) {
                A[j] = a.charAt(i - 1) == b.charAt(j - 1) ? B[j - 1] : Math.min(A[j - 1], Math.min(B[j - 1], B[j])) + 1;
            }
        }
        return A[b.length()];
    }

    public static String closest(String a, Iterable<String> options) {
        int bestv = Integer.MAX_VALUE;
        String bests = null;
        for (String option : options) {
            int v = Levenshtein.distance(a, option);
            if (v >= bestv) continue;
            bestv = v;
            bests = option;
        }
        return bests;
    }

    public static PipeException makeExc(String name, Iterable<String> options, String format) {
        String closest = Levenshtein.closest(name, options);
        return new PipeException(format, name, closest != null ? String.format((Locale)null, " Did you mean '%s'?", closest) : "");
    }
}

