/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.intelie.pipes.Row;
import net.intelie.pipes.types.MapType;
import net.intelie.pipes.types.RowFields;
import net.intelie.pipes.types.RowType;
import net.intelie.pipes.types.SeqType;
import net.intelie.pipes.types.Type;
import net.intelie.pipes.util.Escapes;
import net.intelie.pipes.util.Iterables;

public abstract class LiteralRepresentation {
    public static String toString(Type type, Object value) {
        Type<?> infered = Type.infer(value = type.cast(value));
        if (infered.isAssignableTo(type)) {
            type = infered;
        }
        if (Type.NULL.equals(type) && value == null) {
            return "null";
        }
        if (value == null) {
            return type.makeString(null);
        }
        if (Type.STRING.equals(type)) {
            return "" + Escapes.formatString((String)value);
        }
        if (Type.NUMBER.equals(type) || Type.BOOLEAN.equals(type) || Type.PERIOD.equals(type)) {
            return "" + Type.STRING.cast(value);
        }
        String answer = LiteralRepresentation.tryRow(type, value);
        if (answer != null) {
            return answer;
        }
        answer = LiteralRepresentation.trySequence(type, value);
        if (answer != null) {
            return answer;
        }
        answer = LiteralRepresentation.tryMap(type, value);
        if (answer != null) {
            return answer;
        }
        return type.makeString(value);
    }

    private static String trySequence(Type type, Object value) {
        SeqType extracted = Type.extract(type, SeqType.class);
        if (extracted == null || !(value instanceof Iterable)) {
            return null;
        }
        int count = 0;
        ArrayList<String> list = new ArrayList<String>();
        for (Object obj : (Iterable)value) {
            if (count++ >= 8) {
                return "(" + Iterables.join(", ", list) + ", ...)";
            }
            list.add(LiteralRepresentation.toString(extracted.type(), obj));
        }
        return "(" + Iterables.join(", ", list) + LiteralRepresentation.maybeComma(list) + ")";
    }

    private static String tryMap(Type type, Object value) {
        MapType extracted = Type.extract(type, MapType.class);
        if (extracted == null || !(value instanceof Map)) {
            return null;
        }
        int count = 0;
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry obj : ((Map)value).entrySet()) {
            if (count++ >= 8) {
                list.add("...");
                break;
            }
            list.add(LiteralRepresentation.toString(extracted.keyType(), obj.getKey()));
            list.add(LiteralRepresentation.toString(extracted.valueType(), obj.getValue()));
        }
        return "newmap(" + Iterables.join(", ", list) + LiteralRepresentation.maybeComma(list) + ")";
    }

    private static String maybeComma(List<String> list) {
        return list.size() == 1 ? "," : "";
    }

    private static String tryRow(Type type, Object value) {
        RowType extracted = Type.extract(type, RowType.class);
        if (extracted == null || extracted.fields() == null || !(value instanceof Row)) {
            return null;
        }
        Row row = (Row)value;
        RowFields fields = extracted.fields();
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < fields.size(); ++i) {
            String name = fields.name(i);
            Object obj = i < row.size() ? row.get(i) : null;
            String expr = LiteralRepresentation.toString(fields.type(i), obj);
            String expected = Escapes.safeIdentifier(expr);
            list.add(expr + (!expected.equals(name) ? " as " + name : ""));
        }
        return "(" + Iterables.join(", ", list) + LiteralRepresentation.maybeComma(list) + ")";
    }
}

