/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.util;

import java.util.Arrays;
import net.intelie.pipes.Tree;

public class TreeQueue {
    private int head = 0;
    private int tail = 0;
    private Tree[] list;

    public TreeQueue() {
        this(16);
    }

    public TreeQueue(int size) {
        this.list = new Tree[size];
    }

    public boolean isEmpty() {
        return this.head == this.tail;
    }

    public void enqueue(Tree tree) {
        while (this.next(this.tail) == this.head) {
            this.grow();
        }
        this.list[this.tail] = tree;
        this.tail = this.next(this.tail);
    }

    public Tree get(int index) {
        int size = this.size();
        return this.list[(this.head + (index % size + size) % size) % this.list.length];
    }

    private int next(int index) {
        return (index + 1) % this.list.length;
    }

    private void grow() {
        int size = this.size();
        int newSize = this.list.length + (this.list.length << 1);
        Tree[] newList = new Tree[newSize];
        System.arraycopy(this.list, this.head, newList, 0, this.list.length - this.head);
        System.arraycopy(this.list, 0, newList, this.list.length - this.head, this.head);
        this.head = 0;
        this.tail = size;
        this.list = newList;
    }

    public int size() {
        return (this.tail - this.head + this.list.length) % this.list.length;
    }

    public Tree dequeue() {
        Tree e = this.list[this.head];
        this.list[this.head] = null;
        this.head = this.next(this.head);
        return e;
    }

    public void clear() {
        Arrays.fill(this.list, null);
        this.tail = 0;
        this.head = 0;
    }
}

