/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.util;

public abstract class ValueCache<T> {
    private final long ttl;
    private final T defaultValue;
    private volatile T value;
    private volatile long time = Long.MIN_VALUE;

    public ValueCache(long ttl) {
        this(ttl, null);
    }

    public ValueCache(long ttl, T defaultValue) {
        this.ttl = ttl;
        this.defaultValue = defaultValue;
    }

    public abstract T load() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get() {
        long now = System.nanoTime();
        if (this.checkTtl(now)) {
            ValueCache valueCache = this;
            synchronized (valueCache) {
                if (this.checkTtl(now)) {
                    this.value = this.makeValue();
                    this.time = now;
                }
            }
        }
        return this.value;
    }

    private boolean checkTtl(long now) {
        return now > this.time + this.ttl * 1000000L;
    }

    private T makeValue() {
        try {
            return this.load();
        }
        catch (Throwable e) {
            return this.defaultValue;
        }
    }
}

