/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.flows;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import edu.uci.ics.jung.algorithms.util.IterativeProcess;
import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.util.EdgeType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class EdmondsKarpMaxFlow<V, E>
extends IterativeProcess {
    private DirectedGraph<V, E> mFlowGraph;
    private DirectedGraph<V, E> mOriginalGraph;
    private V source;
    private V target;
    private int mMaxFlow;
    private Set<V> mSourcePartitionNodes;
    private Set<V> mSinkPartitionNodes;
    private Set<E> mMinCutEdges;
    private Map<E, Number> residualCapacityMap = new HashMap<E, Number>();
    private Map<V, V> parentMap = new HashMap<V, V>();
    private Map<V, Number> parentCapacityMap = new HashMap<V, Number>();
    private Function<E, Number> edgeCapacityTransformer;
    private Map<E, Number> edgeFlowMap;
    private Supplier<E> edgeFactory;

    public EdmondsKarpMaxFlow(DirectedGraph<V, E> directedGraph, V source, V sink, Function<E, Number> edgeCapacityTransformer, Map<E, Number> edgeFlowMap, Supplier<E> edgeFactory) {
        if (!directedGraph.getVertices().contains(source) || !directedGraph.getVertices().contains(sink)) {
            throw new IllegalArgumentException("source and sink vertices must be elements of the specified graph");
        }
        if (source.equals(sink)) {
            throw new IllegalArgumentException("source and sink vertices must be distinct");
        }
        this.mOriginalGraph = directedGraph;
        this.source = source;
        this.target = sink;
        this.edgeFlowMap = edgeFlowMap;
        this.edgeCapacityTransformer = edgeCapacityTransformer;
        this.edgeFactory = edgeFactory;
        try {
            this.mFlowGraph = (DirectedGraph)directedGraph.getClass().newInstance();
            for (Object e : this.mOriginalGraph.getEdges()) {
                this.mFlowGraph.addEdge(e, this.mOriginalGraph.getSource(e), this.mOriginalGraph.getDest(e), EdgeType.DIRECTED);
            }
            for (Object v : this.mOriginalGraph.getVertices()) {
                this.mFlowGraph.addVertex(v);
            }
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        this.mMaxFlow = 0;
        this.mSinkPartitionNodes = new HashSet<V>();
        this.mSourcePartitionNodes = new HashSet<V>();
        this.mMinCutEdges = new HashSet();
    }

    private void clearParentValues() {
        this.parentMap.clear();
        this.parentCapacityMap.clear();
        this.parentCapacityMap.put((Number)this.source, Integer.MAX_VALUE);
        this.parentMap.put(this.source, this.source);
    }

    protected boolean hasAugmentingPath() {
        this.mSinkPartitionNodes.clear();
        this.mSourcePartitionNodes.clear();
        this.mSinkPartitionNodes.addAll(this.mFlowGraph.getVertices());
        HashSet visitedEdgesMap = new HashSet();
        LinkedList<Object> queue = new LinkedList<Object>();
        queue.add(this.source);
        while (!queue.isEmpty()) {
            Object currentVertex = queue.remove();
            this.mSinkPartitionNodes.remove(currentVertex);
            this.mSourcePartitionNodes.add(currentVertex);
            Number currentCapacity = this.parentCapacityMap.get(currentVertex);
            Collection neighboringEdges = this.mFlowGraph.getOutEdges(currentVertex);
            for (Object neighboringEdge : neighboringEdges) {
                Object neighboringVertex = this.mFlowGraph.getDest(neighboringEdge);
                Number residualCapacity = this.residualCapacityMap.get(neighboringEdge);
                if (residualCapacity.intValue() <= 0 || visitedEdgesMap.contains(neighboringEdge)) continue;
                V neighborsParent = this.parentMap.get(neighboringVertex);
                Number neighborCapacity = this.parentCapacityMap.get(neighboringVertex);
                int newCapacity = Math.min(residualCapacity.intValue(), currentCapacity.intValue());
                if (neighborsParent != null && newCapacity <= neighborCapacity.intValue()) continue;
                this.parentMap.put(neighboringVertex, currentVertex);
                this.parentCapacityMap.put((Number)neighboringVertex, new Integer(newCapacity));
                visitedEdgesMap.add(neighboringEdge);
                if (neighboringVertex == this.target) continue;
                queue.add(neighboringVertex);
            }
        }
        boolean hasAugmentingPath = false;
        Number targetsParentCapacity = this.parentCapacityMap.get(this.target);
        if (targetsParentCapacity != null && targetsParentCapacity.intValue() > 0) {
            this.updateResidualCapacities();
            hasAugmentingPath = true;
        }
        this.clearParentValues();
        return hasAugmentingPath;
    }

    @Override
    public void step() {
        while (this.hasAugmentingPath()) {
        }
        this.computeMinCut();
    }

    private void computeMinCut() {
        for (Object e : this.mOriginalGraph.getEdges()) {
            Object source = this.mOriginalGraph.getSource(e);
            Object destination = this.mOriginalGraph.getDest(e);
            if (this.mSinkPartitionNodes.contains(source) && this.mSinkPartitionNodes.contains(destination) || this.mSourcePartitionNodes.contains(source) && this.mSourcePartitionNodes.contains(destination) || this.mSinkPartitionNodes.contains(source) && this.mSourcePartitionNodes.contains(destination)) continue;
            this.mMinCutEdges.add(e);
        }
    }

    public int getMaxFlow() {
        return this.mMaxFlow;
    }

    public Set<V> getNodesInSinkPartition() {
        return this.mSinkPartitionNodes;
    }

    public Set<V> getNodesInSourcePartition() {
        return this.mSourcePartitionNodes;
    }

    public Set<E> getMinCutEdges() {
        return this.mMinCutEdges;
    }

    public DirectedGraph<V, E> getFlowGraph() {
        return this.mFlowGraph;
    }

    @Override
    protected void initializeIterations() {
        this.parentCapacityMap.put((Number)this.source, Integer.MAX_VALUE);
        this.parentMap.put(this.source, this.source);
        ArrayList edgeList = new ArrayList(this.mFlowGraph.getEdges());
        for (int eIdx = 0; eIdx < edgeList.size(); ++eIdx) {
            Object edge = edgeList.get(eIdx);
            Number capacity = (Number)this.edgeCapacityTransformer.apply(edge);
            if (capacity == null) {
                throw new IllegalArgumentException("Edge capacities must be provided in Function passed to constructor");
            }
            this.residualCapacityMap.put(edge, capacity);
            Object source = this.mFlowGraph.getSource(edge);
            Object destination = this.mFlowGraph.getDest(edge);
            if (this.mFlowGraph.isPredecessor(source, destination)) continue;
            Object backEdge = this.edgeFactory.get();
            this.mFlowGraph.addEdge(backEdge, destination, source, EdgeType.DIRECTED);
            this.residualCapacityMap.put(backEdge, 0);
        }
    }

    @Override
    protected void finalizeIterations() {
        for (Object currentEdge : this.mFlowGraph.getEdges()) {
            Number capacity = (Number)this.edgeCapacityTransformer.apply(currentEdge);
            Number residualCapacity = this.residualCapacityMap.get(currentEdge);
            if (capacity == null) continue;
            Integer flowValue = new Integer(capacity.intValue() - residualCapacity.intValue());
            this.edgeFlowMap.put(currentEdge, flowValue);
        }
        HashSet backEdges = new HashSet();
        for (Object currentEdge : this.mFlowGraph.getEdges()) {
            if (this.edgeCapacityTransformer.apply(currentEdge) == null) {
                backEdges.add(currentEdge);
                continue;
            }
            this.residualCapacityMap.remove(currentEdge);
        }
        for (Object e : backEdges) {
            this.mFlowGraph.removeEdge(e);
        }
    }

    private void updateResidualCapacities() {
        Number augmentingPathCapacity = this.parentCapacityMap.get(this.target);
        this.mMaxFlow += augmentingPathCapacity.intValue();
        V currentVertex = this.target;
        Object parentVertex = null;
        while (true) {
            V v = this.parentMap.get(currentVertex);
            parentVertex = v;
            if (v == currentVertex) break;
            Object currentEdge = this.mFlowGraph.findEdge(parentVertex, currentVertex);
            Number residualCapacity = this.residualCapacityMap.get(currentEdge);
            residualCapacity = residualCapacity.intValue() - augmentingPathCapacity.intValue();
            this.residualCapacityMap.put(currentEdge, residualCapacity);
            Object backEdge = this.mFlowGraph.findEdge(currentVertex, parentVertex);
            residualCapacity = this.residualCapacityMap.get(backEdge);
            residualCapacity = residualCapacity.intValue() + augmentingPathCapacity.intValue();
            this.residualCapacityMap.put(backEdge, residualCapacity);
            currentVertex = parentVertex;
        }
    }
}

