/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.layout;

import edu.uci.ics.jung.algorithms.layout.GraphElementAccessor;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.graph.Graph;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;

public class RadiusGraphElementAccessor<V, E>
implements GraphElementAccessor<V, E> {
    protected double maxDistance;

    public RadiusGraphElementAccessor() {
        this(Math.sqrt(Double.MAX_VALUE));
    }

    public RadiusGraphElementAccessor(double maxDistance) {
        this.maxDistance = maxDistance;
    }

    @Override
    public V getVertex(Layout<V, E> layout, double x, double y) {
        return this.getVertex(layout, x, y, this.maxDistance);
    }

    public V getVertex(Layout<V, E> layout, double x, double y, double maxDistance) {
        double minDistance = maxDistance * maxDistance;
        V closest = null;
        while (true) {
            try {
                for (Object v : layout.getGraph().getVertices()) {
                    double dy;
                    Point2D p = (Point2D)layout.apply(v);
                    double dx = p.getX() - x;
                    double dist = dx * dx + (dy = p.getY() - y) * dy;
                    if (!(dist < minDistance)) continue;
                    minDistance = dist;
                    closest = (V)v;
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            break;
        }
        return closest;
    }

    @Override
    public Collection<V> getVertices(Layout<V, E> layout, Shape rectangle) {
        HashSet pickedVertices = new HashSet();
        while (true) {
            try {
                for (Object v : layout.getGraph().getVertices()) {
                    Point2D p = (Point2D)layout.apply(v);
                    if (!rectangle.contains(p)) continue;
                    pickedVertices.add(v);
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            break;
        }
        return pickedVertices;
    }

    @Override
    public E getEdge(Layout<V, E> layout, double x, double y) {
        return this.getEdge(layout, x, y, this.maxDistance);
    }

    public E getEdge(Layout<V, E> layout, double x, double y, double maxDistance) {
        double minDistance = maxDistance * maxDistance;
        E closest = null;
        while (true) {
            try {
                for (Object e : layout.getGraph().getEdges()) {
                    double distance2;
                    Graph<V, E> graph = layout.getGraph();
                    Collection vertices = graph.getIncidentVertices(e);
                    Iterator vertexIterator = vertices.iterator();
                    Object v1 = vertexIterator.next();
                    Object v2 = vertexIterator.next();
                    Point2D p1 = (Point2D)layout.apply(v1);
                    Point2D p2 = (Point2D)layout.apply(v2);
                    double x1 = p1.getX();
                    double y1 = p1.getY();
                    double x2 = p2.getX();
                    double y2 = p2.getY();
                    if (x1 == x2 && y1 == y2) continue;
                    double b = ((y - y1) * (y2 - y1) + (x - x1) * (x2 - x1)) / ((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
                    if (b <= 0.0) {
                        distance2 = (x - x1) * (x - x1) + (y - y1) * (y - y1);
                    } else if (b >= 1.0) {
                        distance2 = (x - x2) * (x - x2) + (y - y2) * (y - y2);
                    } else {
                        double x3 = x1 + b * (x2 - x1);
                        double y3 = y1 + b * (y2 - y1);
                        distance2 = (x - x3) * (x - x3) + (y - y3) * (y - y3);
                    }
                    if (!(distance2 < minDistance)) continue;
                    minDistance = distance2;
                    closest = e;
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            break;
        }
        return closest;
    }
}

