/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph;

import com.google.common.base.Supplier;
import edu.uci.ics.jung.graph.UndirectedGraph;
import edu.uci.ics.jung.graph.UndirectedSparseMultigraph;
import edu.uci.ics.jung.graph.util.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;

public class UndirectedOrderedSparseMultigraph<V, E>
extends UndirectedSparseMultigraph<V, E>
implements UndirectedGraph<V, E> {
    public static <V, E> Supplier<UndirectedGraph<V, E>> getFactory() {
        return new Supplier<UndirectedGraph<V, E>>(){

            public UndirectedGraph<V, E> get() {
                return new UndirectedOrderedSparseMultigraph();
            }
        };
    }

    public UndirectedOrderedSparseMultigraph() {
        this.vertices = new LinkedHashMap();
        this.edges = new LinkedHashMap();
    }

    @Override
    public boolean addVertex(V vertex) {
        if (vertex == null) {
            throw new IllegalArgumentException("vertex may not be null");
        }
        if (!this.containsVertex(vertex)) {
            this.vertices.put(vertex, new LinkedHashSet());
            return true;
        }
        return false;
    }

    @Override
    public Collection<V> getNeighbors(V vertex) {
        if (!this.containsVertex(vertex)) {
            return null;
        }
        LinkedHashSet<Object> neighbors = new LinkedHashSet<Object>();
        for (Object edge : this.getIncident_internal(vertex)) {
            Pair endpoints = this.getEndpoints(edge);
            Object e_a = endpoints.getFirst();
            Object e_b = endpoints.getSecond();
            if (vertex.equals(e_a)) {
                neighbors.add(e_b);
                continue;
            }
            neighbors.add(e_a);
        }
        return Collections.unmodifiableCollection(neighbors);
    }
}

