/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph.util;

import edu.uci.ics.jung.graph.AbstractTypedGraph;
import edu.uci.ics.jung.graph.DirectedSparseMultigraph;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.SparseMultigraph;
import edu.uci.ics.jung.graph.UndirectedSparseMultigraph;
import edu.uci.ics.jung.graph.util.EdgeType;
import java.util.ArrayList;
import java.util.HashSet;

public class TestGraphs {
    public static String[][] pairs = new String[][]{{"a", "b", "3"}, {"a", "c", "4"}, {"a", "d", "5"}, {"d", "c", "6"}, {"d", "e", "7"}, {"e", "f", "8"}, {"f", "g", "9"}, {"h", "i", "1"}};

    public static Graph<String, Number> createTestGraph(boolean directed) {
        AbstractTypedGraph graph = null;
        graph = directed ? new DirectedSparseMultigraph() : new UndirectedSparseMultigraph();
        for (int i = 0; i < pairs.length; ++i) {
            String[] pair = pairs[i];
            graph.addEdge(Integer.parseInt(pair[2]), pair[0], pair[1]);
        }
        return graph;
    }

    public static Graph<String, Number> createChainPlusIsolates(int chain_length, int isolate_count) {
        UndirectedSparseMultigraph<String, Number> g = new UndirectedSparseMultigraph<String, Number>();
        if (chain_length > 0) {
            String[] v = new String[chain_length];
            v[0] = "v0";
            g.addVertex(v[0]);
            for (int i = 1; i < chain_length; ++i) {
                v[i] = "v" + i;
                g.addVertex(v[i]);
                g.addEdge(new Double(Math.random()), v[i], v[i - 1]);
            }
        }
        for (int i = 0; i < isolate_count; ++i) {
            String v = "v" + (chain_length + i);
            g.addVertex(v);
        }
        return g;
    }

    public static Graph<String, Number> createDirectedAcyclicGraph(int layers, int maxNodesPerLayer, double linkprob) {
        DirectedSparseMultigraph<String, Number> dag = new DirectedSparseMultigraph<String, Number>();
        HashSet previousLayers = new HashSet();
        HashSet<String> inThisLayer = new HashSet<String>();
        for (int i = 0; i < layers; ++i) {
            int nodesThisLayer = (int)(Math.random() * (double)maxNodesPerLayer) + 1;
            for (int j = 0; j < nodesThisLayer; ++j) {
                String v = i + ":" + j;
                dag.addVertex(v);
                inThisLayer.add(v);
                for (String v2 : previousLayers) {
                    if (!(Math.random() < linkprob)) continue;
                    Double de = new Double(Math.random());
                    dag.addEdge(de, v, v2);
                }
            }
            previousLayers.addAll(inThisLayer);
            inThisLayer.clear();
        }
        return dag;
    }

    private static void createEdge(Graph<String, Number> g, String v1Label, String v2Label, int weight) {
        g.addEdge((Object)new Double(Math.random()), (Object)v1Label, (Object)v2Label);
    }

    public static Graph<String, Number> getOneComponentGraph() {
        String i2;
        String i1;
        int j;
        int i;
        UndirectedSparseMultigraph<String, Number> g = new UndirectedSparseMultigraph<String, Number>();
        for (i = 1; i <= 10; ++i) {
            for (j = i + 1; j <= 10; ++j) {
                i1 = "" + i;
                i2 = "" + j;
                g.addEdge(Math.pow(i + 2, j), i1, i2);
            }
        }
        for (i = 11; i <= 20; ++i) {
            for (j = i + 1; j <= 20; ++j) {
                if (Math.random() > 0.6) continue;
                i1 = "" + i;
                i2 = "" + j;
                g.addEdge(Math.pow(i + 2, j), i1, i2);
            }
        }
        ArrayList index = new ArrayList();
        index.addAll(g.getVertices());
        for (int i3 = 0; i3 < index.size() - 1; ++i3) {
            g.addEdge(new Integer(i3), index.get(i3), index.get(i3 + 1));
        }
        return g;
    }

    public static Graph<String, Number> getDemoGraph() {
        String i2;
        String i1;
        int i;
        UndirectedSparseMultigraph<String, Number> g = new UndirectedSparseMultigraph<String, Number>();
        for (i = 0; i < pairs.length; ++i) {
            String[] pair = pairs[i];
            TestGraphs.createEdge(g, pair[0], pair[1], Integer.parseInt(pair[2]));
        }
        for (i = 1; i <= 10; ++i) {
            for (int j = i + 1; j <= 10; ++j) {
                i1 = "c" + i;
                i2 = "c" + j;
                g.addEdge(Math.pow(i + 2, j), i1, i2);
            }
        }
        for (i = 11; i <= 20; ++i) {
            for (int j = i + 1; j <= 20; ++j) {
                if (Math.random() > 0.6) continue;
                i1 = "p" + i;
                i2 = "p" + j;
                g.addEdge(Math.pow(i + 2, j), i1, i2);
            }
        }
        return g;
    }

    public static Graph<String, Number> getSmallGraph() {
        SparseMultigraph<String, Number> graph = new SparseMultigraph<String, Number>();
        String[] v = new String[3];
        for (int i = 0; i < 3; ++i) {
            v[i] = String.valueOf(i);
            graph.addVertex(v[i]);
        }
        graph.addEdge(new Double(0.0), v[0], v[1], EdgeType.DIRECTED);
        graph.addEdge(new Double(0.1), v[0], v[1], EdgeType.DIRECTED);
        graph.addEdge(new Double(0.2), v[0], v[1], EdgeType.DIRECTED);
        graph.addEdge(new Double(0.3), v[1], v[0], EdgeType.DIRECTED);
        graph.addEdge(new Double(0.4), v[1], v[0], EdgeType.DIRECTED);
        graph.addEdge(new Double(0.5), v[1], v[2]);
        graph.addEdge(new Double(0.6), v[1], v[2]);
        return graph;
    }
}

