/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.com.nimbusds.jose.crypto;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.EncryptionMethod;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.JOSEException;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.JWEAlgorithm;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.crypto.AlgorithmSupportMessage;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.crypto.BaseJWEProvider;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.crypto.ConcatKDF;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.crypto.ContentCryptoProvider;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.jwk.Curve;

abstract class ECDHCryptoProvider
extends BaseJWEProvider {
    public static final Set<JWEAlgorithm> SUPPORTED_ALGORITHMS;
    public static final Set<EncryptionMethod> SUPPORTED_ENCRYPTION_METHODS;
    public static final Set<Curve> SUPPORTED_ELLIPTIC_CURVES;
    private final Curve curve;
    private final ConcatKDF concatKDF;

    static {
        SUPPORTED_ENCRYPTION_METHODS = ContentCryptoProvider.SUPPORTED_ENCRYPTION_METHODS;
        LinkedHashSet<JWEAlgorithm> algs = new LinkedHashSet<JWEAlgorithm>();
        algs.add(JWEAlgorithm.ECDH_ES);
        algs.add(JWEAlgorithm.ECDH_ES_A128KW);
        algs.add(JWEAlgorithm.ECDH_ES_A192KW);
        algs.add(JWEAlgorithm.ECDH_ES_A256KW);
        SUPPORTED_ALGORITHMS = Collections.unmodifiableSet(algs);
        LinkedHashSet<Curve> curves = new LinkedHashSet<Curve>();
        curves.add(Curve.P_256);
        curves.add(Curve.P_384);
        curves.add(Curve.P_521);
        SUPPORTED_ELLIPTIC_CURVES = Collections.unmodifiableSet(curves);
    }

    protected ECDHCryptoProvider(Curve curve) throws JOSEException {
        super(SUPPORTED_ALGORITHMS, ContentCryptoProvider.SUPPORTED_ENCRYPTION_METHODS);
        Curve definedCurve;
        Curve curve2 = definedCurve = curve != null ? curve : new Curve("unknown");
        if (!SUPPORTED_ELLIPTIC_CURVES.contains(curve)) {
            throw new JOSEException(AlgorithmSupportMessage.unsupportedEllipticCurve(definedCurve, SUPPORTED_ELLIPTIC_CURVES));
        }
        this.curve = curve;
        this.concatKDF = new ConcatKDF("SHA-256");
    }

    protected ConcatKDF getConcatKDF() {
        return this.concatKDF;
    }

    public Set<Curve> supportedEllipticCurves() {
        return SUPPORTED_ELLIPTIC_CURVES;
    }

    public Curve getCurve() {
        return this.curve;
    }
}

