/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Serializable;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionInfoEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionInfoEntityManager;

public class SaveProcessDefinitionInfoCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String processDefinitionId;
    protected ObjectNode infoNode;

    public SaveProcessDefinitionInfoCmd(String processDefinitionId, ObjectNode infoNode) {
        this.processDefinitionId = processDefinitionId;
        this.infoNode = infoNode;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (this.processDefinitionId == null) {
            throw new ActivitiIllegalArgumentException("process definition id is null");
        }
        if (this.infoNode == null) {
            throw new ActivitiIllegalArgumentException("process definition info node is null");
        }
        ProcessDefinitionInfoEntityManager definitionInfoEntityManager = commandContext.getProcessDefinitionInfoEntityManager();
        ProcessDefinitionInfoEntity definitionInfoEntity = definitionInfoEntityManager.findProcessDefinitionInfoByProcessDefinitionId(this.processDefinitionId);
        if (definitionInfoEntity == null) {
            definitionInfoEntity = new ProcessDefinitionInfoEntity();
            definitionInfoEntity.setProcessDefinitionId(this.processDefinitionId);
            commandContext.getProcessDefinitionInfoEntityManager().insertProcessDefinitionInfo(definitionInfoEntity);
        } else {
            commandContext.getProcessDefinitionInfoEntityManager().updateProcessDefinitionInfo(definitionInfoEntity);
        }
        if (this.infoNode != null) {
            try {
                ObjectWriter writer = commandContext.getProcessEngineConfiguration().getObjectMapper().writer();
                commandContext.getProcessDefinitionInfoEntityManager().updateInfoJson(definitionInfoEntity.getId(), writer.writeValueAsBytes((Object)this.infoNode));
            }
            catch (Exception e) {
                throw new ActivitiException("Unable to serialize info node " + this.infoNode);
            }
        }
        return null;
    }
}

