/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.client;

import javax.jms.Topic;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.jms.client.ActiveMQDestination;
import org.apache.activemq.artemis.jms.client.ActiveMQSession;

public class ActiveMQTopic
extends ActiveMQDestination
implements Topic {
    private static final long serialVersionUID = 7873614001276404156L;

    public ActiveMQTopic() {
        this((SimpleString)null);
    }

    public ActiveMQTopic(String address) {
        this(address, false);
    }

    public ActiveMQTopic(SimpleString address) {
        super(address, ActiveMQDestination.TYPE.TOPIC, null);
    }

    @Deprecated
    public ActiveMQTopic(String address, String name) {
        super(address, name, ActiveMQDestination.TYPE.TOPIC, null);
    }

    public ActiveMQTopic(String address, boolean temporary) {
        this(address, temporary, null);
    }

    protected ActiveMQTopic(String address, boolean temporary, ActiveMQSession session) {
        super(address, temporary ? ActiveMQDestination.TYPE.TEMP_TOPIC : ActiveMQDestination.TYPE.TOPIC, session);
    }

    public String getTopicName() {
        return this.getName();
    }

    public String toString() {
        return "ActiveMQTopic[" + this.getName() + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ActiveMQTopic)) {
            return false;
        }
        ActiveMQTopic that = (ActiveMQTopic)o;
        return super.getAddress().equals(that.getAddress());
    }

    @Override
    public int hashCode() {
        return super.getAddress().hashCode();
    }
}

