/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.auth.jmx;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Principal;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.security.auth.Subject;
import org.apache.cassandra.auth.AuthCache;
import org.apache.cassandra.auth.AuthenticatedUser;
import org.apache.cassandra.auth.JMXResource;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.auth.PermissionDetails;
import org.apache.cassandra.auth.RoleResource;
import org.apache.cassandra.auth.Roles;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.service.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizationProxy
implements InvocationHandler {
    private static final Logger logger = LoggerFactory.getLogger(AuthorizationProxy.class);
    private static final Set<String> MBEAN_SERVER_METHOD_WHITELIST = ImmutableSet.of((Object)"getDefaultDomain", (Object)"getDomains", (Object)"getMBeanCount", (Object)"hashCode", (Object)"queryMBeans", (Object)"queryNames", (Object[])new String[]{"toString"});
    private static final Set<String> METHOD_BLACKLIST = ImmutableSet.of((Object)"createMBean", (Object)"deserialize", (Object)"getClassLoader", (Object)"getClassLoaderFor", (Object)"instantiate", (Object)"registerMBean", (Object[])new String[]{"unregisterMBean"});
    private static final JMXPermissionsCache permissionsCache = new JMXPermissionsCache();
    private MBeanServer mbs;
    protected Function<RoleResource, Boolean> isSuperuser = Roles::hasSuperuserStatus;
    protected Function<RoleResource, Set<PermissionDetails>> getPermissions = permissionsCache::get;
    protected Supplier<Boolean> isAuthzRequired = () -> DatabaseDescriptor.getAuthorizer().requireAuthorization();
    protected Function<ObjectName, Set<ObjectName>> queryNames = name -> this.mbs.queryNames((ObjectName)name, null);
    protected Supplier<Boolean> isAuthSetupComplete = () -> StorageService.instance.isAuthSetupComplete();

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if ("getMBeanServer".equals(methodName)) {
            throw new SecurityException("Access denied");
        }
        AccessControlContext acc = AccessController.getContext();
        Subject subject = Subject.getSubject(acc);
        if ("setMBeanServer".equals(methodName)) {
            if (subject != null) {
                throw new SecurityException("Access denied");
            }
            if (args[0] == null) {
                throw new IllegalArgumentException("Null MBeanServer");
            }
            if (this.mbs != null) {
                throw new IllegalArgumentException("MBeanServer already initialized");
            }
            this.mbs = (MBeanServer)args[0];
            return null;
        }
        if (this.authorize(subject, methodName, args)) {
            return this.invoke(method, args);
        }
        throw new SecurityException("Access Denied");
    }

    @VisibleForTesting
    boolean authorize(Subject subject, String methodName, Object[] args) {
        logger.trace("Authorizing JMX method invocation {} for {}", (Object)methodName, (Object)(subject == null ? "" : subject.toString().replaceAll("\\n", " ")));
        if (!this.isAuthSetupComplete.get().booleanValue()) {
            logger.trace("Auth setup is not complete, refusing access");
            return false;
        }
        if (!this.isAuthzRequired.get().booleanValue()) {
            return true;
        }
        if (subject == null) {
            return true;
        }
        if (METHOD_BLACKLIST.contains(methodName)) {
            logger.trace("Access denied to blacklisted method {}", (Object)methodName);
            return false;
        }
        Set<Principal> principals = subject.getPrincipals();
        if (principals == null || principals.isEmpty()) {
            return false;
        }
        RoleResource userResource = RoleResource.role(principals.iterator().next().getName());
        if (this.isSuperuser.apply(userResource).booleanValue()) {
            return true;
        }
        if (args != null && args[0] instanceof ObjectName) {
            return this.authorizeMBeanMethod(userResource, methodName, args);
        }
        return this.authorizeMBeanServerMethod(userResource, methodName);
    }

    private boolean authorizeMBeanServerMethod(RoleResource subject, String methodName) {
        logger.trace("JMX invocation of {} on MBeanServer requires permission {}", (Object)methodName, (Object)Permission.DESCRIBE);
        return MBEAN_SERVER_METHOD_WHITELIST.contains(methodName) && this.hasPermission(subject, Permission.DESCRIBE, JMXResource.root());
    }

    private boolean authorizeMBeanMethod(RoleResource role, String methodName, Object[] args) {
        ObjectName targetBean = (ObjectName)args[0];
        Permission requiredPermission = AuthorizationProxy.getRequiredPermission(methodName);
        if (null == requiredPermission) {
            return false;
        }
        logger.trace("JMX invocation of {} on {} requires permission {}", new Object[]{methodName, targetBean, requiredPermission});
        Set<JMXResource> permittedResources = this.getPermittedResources(role, requiredPermission);
        if (permittedResources.isEmpty()) {
            return false;
        }
        return targetBean.isPattern() ? this.checkPattern(targetBean, permittedResources) : this.checkExact(targetBean, permittedResources);
    }

    private Set<JMXResource> getPermittedResources(RoleResource subject, Permission required) {
        return this.getPermissions.apply(subject).stream().filter(details -> details.permission == required).map(details -> (JMXResource)details.resource).collect(Collectors.toSet());
    }

    private boolean hasPermission(RoleResource subject, Permission permission, JMXResource resource) {
        return this.getPermissions.apply(subject).stream().anyMatch(details -> details.permission == permission && details.resource.equals(resource));
    }

    private boolean checkPattern(ObjectName target, Set<JMXResource> permittedResources) {
        if (permittedResources.contains(JMXResource.root())) {
            return true;
        }
        Set<ObjectName> targetNames = this.queryNames.apply(target);
        for (JMXResource resource : permittedResources) {
            try {
                Set<ObjectName> matchingNames = this.queryNames.apply(ObjectName.getInstance(resource.getObjectName()));
                targetNames.removeAll(matchingNames);
                if (!targetNames.isEmpty()) continue;
                return true;
            }
            catch (MalformedObjectNameException e) {
                logger.warn("Permissions for JMX resource contains invalid ObjectName {}", (Object)resource.getObjectName());
            }
        }
        logger.trace("Subject does not have sufficient permissions on all MBeans matching the target pattern {}", (Object)target);
        return false;
    }

    private boolean checkExact(ObjectName target, Set<JMXResource> permittedResources) {
        if (permittedResources.contains(JMXResource.root())) {
            return true;
        }
        for (JMXResource resource : permittedResources) {
            try {
                if (!ObjectName.getInstance(resource.getObjectName()).apply(target)) continue;
                return true;
            }
            catch (MalformedObjectNameException e) {
                logger.warn("Permissions for JMX resource contains invalid ObjectName {}", (Object)resource.getObjectName());
            }
        }
        logger.trace("Subject does not have sufficient permissions on target MBean {}", (Object)target);
        return false;
    }

    private static Permission getRequiredPermission(String methodName) {
        switch (methodName) {
            case "getAttribute": 
            case "getAttributes": {
                return Permission.SELECT;
            }
            case "setAttribute": 
            case "setAttributes": {
                return Permission.MODIFY;
            }
            case "invoke": {
                return Permission.EXECUTE;
            }
            case "getInstanceOf": 
            case "getMBeanInfo": 
            case "hashCode": 
            case "isInstanceOf": 
            case "isRegistered": 
            case "queryMBeans": 
            case "queryNames": {
                return Permission.DESCRIBE;
            }
        }
        logger.debug("Access denied, method name {} does not map to any defined permission", (Object)methodName);
        return null;
    }

    private Object invoke(Method method, Object[] args) throws Throwable {
        try {
            return method.invoke((Object)this.mbs, args);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getCause();
            throw t;
        }
    }

    private static Set<PermissionDetails> loadPermissions(RoleResource subject) {
        return DatabaseDescriptor.getAuthorizer().list(AuthenticatedUser.SYSTEM_USER, Permission.ALL, null, subject).stream().filter(details -> details.resource instanceof JMXResource).collect(Collectors.toSet());
    }

    private static final class JMXPermissionsCache
    extends AuthCache<RoleResource, Set<PermissionDetails>> {
        protected JMXPermissionsCache() {
            super("JMXPermissionsCache", DatabaseDescriptor::setPermissionsValidity, DatabaseDescriptor::getPermissionsValidity, DatabaseDescriptor::setPermissionsUpdateInterval, DatabaseDescriptor::getPermissionsUpdateInterval, DatabaseDescriptor::setPermissionsCacheMaxEntries, DatabaseDescriptor::getPermissionsCacheMaxEntries, x$0 -> AuthorizationProxy.loadPermissions(x$0), () -> true);
        }

        @Override
        public Set<PermissionDetails> get(RoleResource roleResource) {
            try {
                return (Set)super.get(roleResource);
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }
}

