/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair;

import java.net.InetAddress;
import java.util.List;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.repair.RepairJobDesc;
import org.apache.cassandra.repair.SyncTask;
import org.apache.cassandra.repair.TreeResponse;
import org.apache.cassandra.service.ActiveRepairService;
import org.apache.cassandra.streaming.ProgressInfo;
import org.apache.cassandra.streaming.StreamEvent;
import org.apache.cassandra.streaming.StreamEventHandler;
import org.apache.cassandra.streaming.StreamPlan;
import org.apache.cassandra.streaming.StreamState;
import org.apache.cassandra.tracing.TraceState;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalSyncTask
extends SyncTask
implements StreamEventHandler {
    private final TraceState state = Tracing.instance.get();
    private static final Logger logger = LoggerFactory.getLogger(LocalSyncTask.class);
    private final long repairedAt;
    private final boolean pullRepair;

    public LocalSyncTask(RepairJobDesc desc, TreeResponse r1, TreeResponse r2, long repairedAt, boolean pullRepair) {
        super(desc, r1, r2);
        this.repairedAt = repairedAt;
        this.pullRepair = pullRepair;
    }

    @Override
    protected void startSync(List<Range<Token>> differences) {
        InetAddress local = FBUtilities.getBroadcastAddress();
        InetAddress dst = this.r2.endpoint.equals(local) ? this.r1.endpoint : this.r2.endpoint;
        InetAddress preferred = SystemKeyspace.getPreferredIP(dst);
        String message = String.format("Performing streaming repair of %d ranges with %s", differences.size(), dst);
        logger.info("[repair #{}] {}", (Object)this.desc.sessionId, (Object)message);
        boolean isIncremental = false;
        if (this.desc.parentSessionId != null) {
            ActiveRepairService.ParentRepairSession prs = ActiveRepairService.instance.getParentRepairSession(this.desc.parentSessionId);
            isIncremental = prs.isIncremental;
        }
        Tracing.traceRepair(message, new Object[0]);
        StreamPlan plan = new StreamPlan("Repair", this.repairedAt, 1, false, isIncremental, false).listeners(this, new StreamEventHandler[0]).flushBeforeTransfer(true).requestRanges(dst, preferred, this.desc.keyspace, differences, this.desc.columnFamily);
        if (!this.pullRepair) {
            plan.transferRanges(dst, preferred, this.desc.keyspace, differences, this.desc.columnFamily);
        }
        plan.execute();
    }

    @Override
    public void handleStreamEvent(StreamEvent event) {
        if (this.state == null) {
            return;
        }
        switch (event.eventType) {
            case STREAM_PREPARED: {
                StreamEvent.SessionPreparedEvent spe = (StreamEvent.SessionPreparedEvent)event;
                this.state.trace("Streaming session with {} prepared", spe.session.peer);
                break;
            }
            case STREAM_COMPLETE: {
                StreamEvent.SessionCompleteEvent sce = (StreamEvent.SessionCompleteEvent)event;
                this.state.trace("Streaming session with {} {}", sce.peer, sce.success ? "completed successfully" : "failed");
                break;
            }
            case FILE_PROGRESS: {
                ProgressInfo pi = ((StreamEvent.ProgressEvent)event).progress;
                this.state.trace("{}/{} ({}%) {} idx:{}{}", new Object[]{FBUtilities.prettyPrintMemory(pi.currentBytes), FBUtilities.prettyPrintMemory(pi.totalBytes), pi.currentBytes * 100L / pi.totalBytes, pi.direction == ProgressInfo.Direction.OUT ? "sent to" : "received from", pi.sessionIndex, pi.peer});
            }
        }
    }

    public void onSuccess(StreamState result) {
        String message = String.format("Sync complete using session %s between %s and %s on %s", this.desc.sessionId, this.r1.endpoint, this.r2.endpoint, this.desc.columnFamily);
        logger.info("[repair #{}] {}", (Object)this.desc.sessionId, (Object)message);
        Tracing.traceRepair(message, new Object[0]);
        this.set(this.stat);
    }

    public void onFailure(Throwable t) {
        this.setException(t);
    }
}

