/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.protocolrecords.impl.pb;

import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ResourceBlacklistRequest;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.impl.pb.ContainerIdPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ResourceBlacklistRequestPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ResourceRequestPBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.proto.YarnServiceProtos;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class AllocateRequestPBImpl
extends AllocateRequest {
    YarnServiceProtos.AllocateRequestProto proto = YarnServiceProtos.AllocateRequestProto.getDefaultInstance();
    YarnServiceProtos.AllocateRequestProto.Builder builder = null;
    boolean viaProto = false;
    private List<ResourceRequest> ask = null;
    private List<ContainerId> release = null;
    private ResourceBlacklistRequest blacklistRequest = null;

    public AllocateRequestPBImpl() {
        this.builder = YarnServiceProtos.AllocateRequestProto.newBuilder();
    }

    public AllocateRequestPBImpl(YarnServiceProtos.AllocateRequestProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public YarnServiceProtos.AllocateRequestProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    public int hashCode() {
        return this.getProto().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(((Object)((Object)this)).getClass())) {
            return this.getProto().equals((Object)((AllocateRequestPBImpl)((Object)((Object)((Object)this)).getClass().cast(other))).getProto());
        }
        return false;
    }

    public String toString() {
        return TextFormat.shortDebugString((MessageOrBuilder)this.getProto());
    }

    private void mergeLocalToBuilder() {
        if (this.ask != null) {
            this.addAsksToProto();
        }
        if (this.release != null) {
            this.addReleasesToProto();
        }
        if (this.blacklistRequest != null) {
            this.builder.setBlacklistRequest(this.convertToProtoFormat(this.blacklistRequest));
        }
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnServiceProtos.AllocateRequestProto.newBuilder((YarnServiceProtos.AllocateRequestProto)this.proto);
        }
        this.viaProto = false;
    }

    public int getResponseId() {
        YarnServiceProtos.AllocateRequestProto p = this.viaProto ? this.proto : this.builder;
        return p.getResponseId();
    }

    public void setResponseId(int id) {
        this.maybeInitBuilder();
        this.builder.setResponseId(id);
    }

    public float getProgress() {
        YarnServiceProtos.AllocateRequestProto p = this.viaProto ? this.proto : this.builder;
        return p.getProgress();
    }

    public void setProgress(float progress) {
        this.maybeInitBuilder();
        this.builder.setProgress(progress);
    }

    public List<ResourceRequest> getAskList() {
        this.initAsks();
        return this.ask;
    }

    public void setAskList(List<ResourceRequest> resourceRequests) {
        if (resourceRequests == null) {
            return;
        }
        this.initAsks();
        this.ask.clear();
        this.ask.addAll(resourceRequests);
    }

    public ResourceBlacklistRequest getResourceBlacklistRequest() {
        YarnServiceProtos.AllocateRequestProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (this.blacklistRequest != null) {
            return this.blacklistRequest;
        }
        if (!p.hasBlacklistRequest()) {
            return null;
        }
        this.blacklistRequest = this.convertFromProtoFormat(p.getBlacklistRequest());
        return this.blacklistRequest;
    }

    public void setResourceBlacklistRequest(ResourceBlacklistRequest blacklistRequest) {
        this.maybeInitBuilder();
        if (blacklistRequest == null) {
            this.builder.clearBlacklistRequest();
        }
        this.blacklistRequest = blacklistRequest;
    }

    private void initAsks() {
        if (this.ask != null) {
            return;
        }
        YarnServiceProtos.AllocateRequestProto p = this.viaProto ? this.proto : this.builder;
        List list = p.getAskList();
        this.ask = new ArrayList<ResourceRequest>();
        for (YarnProtos.ResourceRequestProto c : list) {
            this.ask.add(this.convertFromProtoFormat(c));
        }
    }

    private void addAsksToProto() {
        this.maybeInitBuilder();
        this.builder.clearAsk();
        if (this.ask == null) {
            return;
        }
        Iterable<YarnProtos.ResourceRequestProto> iterable = new Iterable<YarnProtos.ResourceRequestProto>(){

            @Override
            public Iterator<YarnProtos.ResourceRequestProto> iterator() {
                return new Iterator<YarnProtos.ResourceRequestProto>(){
                    Iterator<ResourceRequest> iter;
                    {
                        this.iter = AllocateRequestPBImpl.this.ask.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public YarnProtos.ResourceRequestProto next() {
                        return AllocateRequestPBImpl.this.convertToProtoFormat(this.iter.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
        this.builder.addAllAsk((Iterable)iterable);
    }

    public List<ContainerId> getReleaseList() {
        this.initReleases();
        return this.release;
    }

    public void setReleaseList(List<ContainerId> releaseContainers) {
        if (releaseContainers == null) {
            return;
        }
        this.initReleases();
        this.release.clear();
        this.release.addAll(releaseContainers);
    }

    private void initReleases() {
        if (this.release != null) {
            return;
        }
        YarnServiceProtos.AllocateRequestProto p = this.viaProto ? this.proto : this.builder;
        List list = p.getReleaseList();
        this.release = new ArrayList<ContainerId>();
        for (YarnProtos.ContainerIdProto c : list) {
            this.release.add(this.convertFromProtoFormat(c));
        }
    }

    private void addReleasesToProto() {
        this.maybeInitBuilder();
        this.builder.clearRelease();
        if (this.release == null) {
            return;
        }
        Iterable<YarnProtos.ContainerIdProto> iterable = new Iterable<YarnProtos.ContainerIdProto>(){

            @Override
            public Iterator<YarnProtos.ContainerIdProto> iterator() {
                return new Iterator<YarnProtos.ContainerIdProto>(){
                    Iterator<ContainerId> iter;
                    {
                        this.iter = AllocateRequestPBImpl.this.release.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public YarnProtos.ContainerIdProto next() {
                        return AllocateRequestPBImpl.this.convertToProtoFormat(this.iter.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
        this.builder.addAllRelease((Iterable)iterable);
    }

    private ResourceRequestPBImpl convertFromProtoFormat(YarnProtos.ResourceRequestProto p) {
        return new ResourceRequestPBImpl(p);
    }

    private YarnProtos.ResourceRequestProto convertToProtoFormat(ResourceRequest t) {
        return ((ResourceRequestPBImpl)t).getProto();
    }

    private ContainerIdPBImpl convertFromProtoFormat(YarnProtos.ContainerIdProto p) {
        return new ContainerIdPBImpl(p);
    }

    private YarnProtos.ContainerIdProto convertToProtoFormat(ContainerId t) {
        return ((ContainerIdPBImpl)t).getProto();
    }

    private ResourceBlacklistRequestPBImpl convertFromProtoFormat(YarnProtos.ResourceBlacklistRequestProto p) {
        return new ResourceBlacklistRequestPBImpl(p);
    }

    private YarnProtos.ResourceBlacklistRequestProto convertToProtoFormat(ResourceBlacklistRequest t) {
        return ((ResourceBlacklistRequestPBImpl)t).getProto();
    }
}

