/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.File;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.log.FileMessageSet;
import kafka.log.Log$;
import kafka.log.OffsetIndex;
import kafka.log.OffsetIndex$;
import kafka.log.OffsetPosition;
import kafka.message.ByteBufferMessageSet$;
import kafka.message.CompressionCodec;
import kafka.message.Message;
import kafka.message.MessageAndOffset;
import kafka.message.MessageSet$;
import kafka.message.NoCompressionCodec$;
import kafka.serializer.Decoder;
import kafka.tools.DumpLogSegments$$anonfun$kafka$tools$DumpLogSegments$;
import kafka.utils.CommandLineUtils$;
import kafka.utils.IteratorTemplate;
import kafka.utils.Utils$;
import kafka.utils.VerifiableProperties;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;

public final class DumpLogSegments$ {
    public static final DumpLogSegments$ MODULE$;

    static {
        new DumpLogSegments$();
    }

    public void main(String[] args) {
        OptionParser parser = new OptionParser();
        OptionSpecBuilder printOpt = parser.accepts("print-data-log", "if set, printing the messages content when dumping data logs");
        OptionSpecBuilder verifyOpt = parser.accepts("verify-index-only", "if set, just verify the index log without printing its content");
        ArgumentAcceptingOptionSpec filesOpt = parser.accepts("files", "REQUIRED: The comma separated list of data and index log files to be dumped").withRequiredArg().describedAs("file1, file2, ...").ofType(String.class);
        ArgumentAcceptingOptionSpec maxMessageSizeOpt = parser.accepts("max-message-size", "Size of largest message.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(0x500000), (Object[])new Integer[0]);
        OptionSpecBuilder deepIterationOpt = parser.accepts("deep-iteration", "if set, uses deep instead of shallow iteration");
        ArgumentAcceptingOptionSpec valueDecoderOpt = parser.accepts("value-decoder-class", "if set, used to deserialize the messages. This class should implement kafka.serializer.Decoder trait. Custom jar should be available in kafka/libs directory.").withOptionalArg().ofType(String.class).defaultsTo((Object)"kafka.serializer.StringDecoder", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec keyDecoderOpt = parser.accepts("key-decoder-class", "if set, used to deserialize the keys. This class should implement kafka.serializer.Decoder trait. Custom jar should be available in kafka/libs directory.").withOptionalArg().ofType(String.class).defaultsTo((Object)"kafka.serializer.StringDecoder", (Object[])new String[0]);
        if (args.length == 0) {
            CommandLineUtils$.MODULE$.printUsageAndDie(parser, "Parse a log file and dump its contents to the console, useful for debugging a seemingly corrupt log segment.");
        }
        OptionSet options = parser.parse(args);
        CommandLineUtils$.MODULE$.checkRequiredArgs(parser, options, (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{filesOpt}));
        boolean print = options.has((OptionSpec)printOpt);
        boolean verifyOnly = options.has((OptionSpec)verifyOpt);
        String[] files = ((String)options.valueOf((OptionSpec)filesOpt)).split(",");
        int maxMessageSize = (Integer)options.valueOf((OptionSpec)maxMessageSizeOpt);
        boolean isDeepIteration = options.has((OptionSpec)deepIterationOpt);
        Decoder valueDecoder = (Decoder)Utils$.MODULE$.createObject((String)options.valueOf((OptionSpec)valueDecoderOpt), (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{new VerifiableProperties()}));
        Decoder keyDecoder = (Decoder)Utils$.MODULE$.createObject((String)options.valueOf((OptionSpec)keyDecoderOpt), (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{new VerifiableProperties()}));
        HashMap misMatchesForIndexFilesMap = new HashMap();
        HashMap nonConsecutivePairsForLogFilesMap = new HashMap();
        Predef$.MODULE$.refArrayOps((Object[])files).foreach((Function1)new Serializable(print, verifyOnly, maxMessageSize, isDeepIteration, valueDecoder, keyDecoder, misMatchesForIndexFilesMap, nonConsecutivePairsForLogFilesMap){
            public static final long serialVersionUID = 0L;
            private final boolean print$1;
            private final boolean verifyOnly$1;
            private final int maxMessageSize$1;
            private final boolean isDeepIteration$1;
            private final Decoder valueDecoder$1;
            private final Decoder keyDecoder$1;
            private final HashMap misMatchesForIndexFilesMap$1;
            private final HashMap nonConsecutivePairsForLogFilesMap$1;

            public final void apply(String arg) {
                File file = new File(arg);
                if (file.getName().endsWith(Log$.MODULE$.LogFileSuffix())) {
                    Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Dumping ").append((Object)file).toString());
                    DumpLogSegments$.MODULE$.kafka$tools$DumpLogSegments$$dumpLog(file, this.print$1, (HashMap<String, List<Tuple2<Object, Object>>>)this.nonConsecutivePairsForLogFilesMap$1, this.isDeepIteration$1, this.maxMessageSize$1, this.valueDecoder$1, this.keyDecoder$1);
                } else if (file.getName().endsWith(Log$.MODULE$.IndexFileSuffix())) {
                    Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Dumping ").append((Object)file).toString());
                    DumpLogSegments$.MODULE$.kafka$tools$DumpLogSegments$$dumpIndex(file, this.verifyOnly$1, (HashMap<String, List<Tuple2<Object, Object>>>)this.misMatchesForIndexFilesMap$1, this.maxMessageSize$1);
                }
            }
            {
                this.print$1 = print$1;
                this.verifyOnly$1 = verifyOnly$1;
                this.maxMessageSize$1 = maxMessageSize$1;
                this.isDeepIteration$1 = isDeepIteration$1;
                this.valueDecoder$1 = valueDecoder$1;
                this.keyDecoder$1 = keyDecoder$1;
                this.misMatchesForIndexFilesMap$1 = misMatchesForIndexFilesMap$1;
                this.nonConsecutivePairsForLogFilesMap$1 = nonConsecutivePairsForLogFilesMap$1;
            }
        });
        misMatchesForIndexFilesMap.foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Tuple2<String, List<Tuple2<Object, Object>>> x0$1) {
                Tuple2<String, List<Tuple2<Object, Object>>> tuple2 = x0$1;
                if (tuple2 != null) {
                    String fileName = (String)tuple2._1();
                    List listOfMismatches = (List)tuple2._2();
                    System.err.println(new StringBuilder().append((Object)"Mismatches in :").append((Object)fileName).toString());
                    listOfMismatches.foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final void apply(Tuple2<Object, Object> m) {
                            System.err.println(new StringOps(Predef$.MODULE$.augmentString("  Index offset: %d, log offset: %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)m._1$mcJ$sp()), BoxesRunTime.boxToLong((long)m._2$mcJ$sp())})));
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
        });
        nonConsecutivePairsForLogFilesMap.foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Tuple2<String, List<Tuple2<Object, Object>>> x0$2) {
                Tuple2<String, List<Tuple2<Object, Object>>> tuple2 = x0$2;
                if (tuple2 != null) {
                    String fileName = (String)tuple2._1();
                    List listOfNonConsecutivePairs = (List)tuple2._2();
                    System.err.println(new StringBuilder().append((Object)"Non-secutive offsets in :").append((Object)fileName).toString());
                    listOfNonConsecutivePairs.foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final void apply(Tuple2<Object, Object> m) {
                            System.err.println(new StringOps(Predef$.MODULE$.augmentString("  %d is followed by %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)m._1$mcJ$sp()), BoxesRunTime.boxToLong((long)m._2$mcJ$sp())})));
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
        });
    }

    public void kafka$tools$DumpLogSegments$$dumpIndex(File file, boolean verifyOnly, HashMap<String, List<Tuple2<Object, Object>>> misMatchesForIndexFilesMap, int maxMessageSize) {
        NonLocalReturnControl nonLocalReturnControl2;
        block2: {
            Object object = new Object();
            try {
                long startOffset = new StringOps(Predef$.MODULE$.augmentString(file.getName().split("\\.")[0])).toLong();
                File logFile = new File(file.getAbsoluteFile().getParent(), new StringBuilder().append((Object)file.getName().split("\\.")[0]).append((Object)Log$.MODULE$.LogFileSuffix()).toString());
                FileMessageSet messageSet = new FileMessageSet(logFile, false);
                OffsetIndex index = new OffsetIndex(file, startOffset, OffsetIndex$.MODULE$.$lessinit$greater$default$3());
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), index.entries()).foreach$mVc$sp((Function1)new Serializable(file, verifyOnly, misMatchesForIndexFilesMap, maxMessageSize, messageSet, index, object){
                    public static final long serialVersionUID = 0L;
                    private final File file$2;
                    private final boolean verifyOnly$2;
                    private final HashMap misMatchesForIndexFilesMap$2;
                    private final int maxMessageSize$2;
                    private final FileMessageSet messageSet$1;
                    private final OffsetIndex index$1;
                    private final Object nonLocalReturnKey1$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        BoxedUnit boxedUnit;
                        OffsetPosition entry2 = this.index$1.entry(i);
                        FileMessageSet partialFileMessageSet = this.messageSet$1.read(entry2.position(), this.maxMessageSize$2);
                        MessageAndOffset messageAndOffset = (MessageAndOffset)DumpLogSegments$.MODULE$.kafka$tools$DumpLogSegments$$getIterator((MessageAndOffset)partialFileMessageSet.head(), true).next();
                        if (messageAndOffset.offset() != entry2.offset() + this.index$1.baseOffset()) {
                            List misMatchesSeq = (List)this.misMatchesForIndexFilesMap$2.getOrElse((Object)this.file$2.getAbsolutePath(), (Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final List<Tuple2<Object, Object>> apply() {
                                    return Nil$.MODULE$;
                                }
                            });
                            misMatchesSeq = misMatchesSeq.$colon$colon((Object)new Tuple2.mcJJ.sp(entry2.offset() + this.index$1.baseOffset(), messageAndOffset.offset()));
                            boxedUnit = this.misMatchesForIndexFilesMap$2.put((Object)this.file$2.getAbsolutePath(), (Object)misMatchesSeq);
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        if (entry2.offset() == 0L && i > 0) {
                            throw new NonLocalReturnControl.mcV.sp(this.nonLocalReturnKey1$1, BoxedUnit.UNIT);
                        }
                        if (!this.verifyOnly$2) {
                            Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("offset: %d position: %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(entry2.offset() + this.index$1.baseOffset())), BoxesRunTime.boxToInteger((int)entry2.position())})));
                        }
                    }
                    {
                        this.file$2 = file$2;
                        this.verifyOnly$2 = verifyOnly$2;
                        this.misMatchesForIndexFilesMap$2 = misMatchesForIndexFilesMap$2;
                        this.maxMessageSize$2 = maxMessageSize$2;
                        this.messageSet$1 = messageSet$1;
                        this.index$1 = index$1;
                        this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                    }
                });
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block2;
                nonLocalReturnControl2.value$mcV$sp();
            }
            return;
        }
        throw nonLocalReturnControl2;
    }

    public void kafka$tools$DumpLogSegments$$dumpLog(File file, boolean printContents, HashMap<String, List<Tuple2<Object, Object>>> nonConsecutivePairsForLogFilesMap, boolean isDeepIteration, int maxMessageSize, Decoder<?> valueDecoder, Decoder<?> keyDecoder) {
        long startOffset = new StringOps(Predef$.MODULE$.augmentString(file.getName().split("\\.")[0])).toLong();
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Starting offset: ").append((Object)BoxesRunTime.boxToLong((long)startOffset)).toString());
        FileMessageSet messageSet = new FileMessageSet(file, false);
        LongRef validBytes = new LongRef(0L);
        LongRef lastOffset = new LongRef(-1L);
        Iterator<MessageAndOffset> shallowIterator = messageSet.iterator(maxMessageSize);
        shallowIterator.foreach((Function1)new Serializable(file, printContents, nonConsecutivePairsForLogFilesMap, isDeepIteration, valueDecoder, keyDecoder, validBytes, lastOffset){
            public static final long serialVersionUID = 0L;
            public final File file$1;
            public final boolean printContents$1;
            public final HashMap nonConsecutivePairsForLogFilesMap$2;
            private final boolean isDeepIteration$2;
            public final Decoder valueDecoder$2;
            public final Decoder keyDecoder$2;
            public final LongRef validBytes$1;
            public final LongRef lastOffset$1;

            public final void apply(MessageAndOffset shallowMessageAndOffset) {
                Iterator<MessageAndOffset> itr = DumpLogSegments$.MODULE$.kafka$tools$DumpLogSegments$$getIterator(shallowMessageAndOffset, this.isDeepIteration$2);
                itr.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun$kafka$tools$DumpLogSegments$$dumpLog$1 $outer;

                    public final void apply(MessageAndOffset messageAndOffset) {
                        BoxedUnit boxedUnit;
                        Message msg = messageAndOffset.message();
                        if (this.$outer.lastOffset$1.elem == -1L) {
                            this.$outer.lastOffset$1.elem = messageAndOffset.offset();
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            CompressionCodec compressionCodec = msg.compressionCodec();
                            NoCompressionCodec$ noCompressionCodec$ = NoCompressionCodec$.MODULE$;
                            if (!(compressionCodec != null ? !compressionCodec.equals(noCompressionCodec$) : noCompressionCodec$ != null) && messageAndOffset.offset() != this.$outer.lastOffset$1.elem + 1L) {
                                List nonConsecutivePairsSeq = (List)this.$outer.nonConsecutivePairsForLogFilesMap$2.getOrElse((Object)this.$outer.file$1.getAbsolutePath(), (Function0)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final List<Tuple2<Object, Object>> apply() {
                                        return Nil$.MODULE$;
                                    }
                                });
                                nonConsecutivePairsSeq = nonConsecutivePairsSeq.$colon$colon((Object)new Tuple2.mcJJ.sp(this.$outer.lastOffset$1.elem, messageAndOffset.offset()));
                                boxedUnit = this.$outer.nonConsecutivePairsForLogFilesMap$2.put((Object)this.$outer.file$1.getAbsolutePath(), (Object)nonConsecutivePairsSeq);
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                        }
                        this.$outer.lastOffset$1.elem = messageAndOffset.offset();
                        Predef$.MODULE$.print((Object)new StringBuilder().append((Object)"offset: ").append((Object)BoxesRunTime.boxToLong((long)messageAndOffset.offset())).append((Object)" position: ").append((Object)BoxesRunTime.boxToLong((long)this.$outer.validBytes$1.elem)).append((Object)" isvalid: ").append((Object)BoxesRunTime.boxToBoolean((boolean)msg.isValid())).append((Object)" payloadsize: ").append((Object)BoxesRunTime.boxToInteger((int)msg.payloadSize())).append((Object)" magic: ").append((Object)BoxesRunTime.boxToByte((byte)msg.magic())).append((Object)" compresscodec: ").append((Object)msg.compressionCodec()).append((Object)" crc: ").append((Object)BoxesRunTime.boxToLong((long)msg.checksum())).toString());
                        if (msg.hasKey()) {
                            Predef$.MODULE$.print((Object)new StringBuilder().append((Object)" keysize: ").append((Object)BoxesRunTime.boxToInteger((int)msg.keySize())).toString());
                        }
                        if (this.$outer.printContents$1) {
                            if (msg.hasKey()) {
                                Predef$.MODULE$.print((Object)new StringBuilder().append((Object)" key: ").append(this.$outer.keyDecoder$2.fromBytes(Utils$.MODULE$.readBytes(messageAndOffset.message().key()))).toString());
                            }
                            Object payload = messageAndOffset.message().isNull() ? null : this.$outer.valueDecoder$2.fromBytes(Utils$.MODULE$.readBytes(messageAndOffset.message().payload()));
                            Predef$.MODULE$.print((Object)new StringBuilder().append((Object)" payload: ").append(payload).toString());
                        }
                        Predef$.MODULE$.println();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                this.validBytes$1.elem += (long)MessageSet$.MODULE$.entrySize(shallowMessageAndOffset.message());
            }
            {
                this.file$1 = file$1;
                this.printContents$1 = printContents$1;
                this.nonConsecutivePairsForLogFilesMap$2 = nonConsecutivePairsForLogFilesMap$2;
                this.isDeepIteration$2 = isDeepIteration$2;
                this.valueDecoder$2 = valueDecoder$2;
                this.keyDecoder$2 = keyDecoder$2;
                this.validBytes$1 = validBytes$1;
                this.lastOffset$1 = lastOffset$1;
            }
        });
        long trailingBytes = (long)messageSet.sizeInBytes() - validBytes.elem;
        if (trailingBytes > 0L) {
            Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Found %d invalid bytes at the end of %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)trailingBytes), file.getName()})));
        }
    }

    public Iterator<MessageAndOffset> kafka$tools$DumpLogSegments$$getIterator(MessageAndOffset messageAndOffset, boolean isDeepIteration) {
        IteratorTemplate<MessageAndOffset> iteratorTemplate;
        if (isDeepIteration) {
            Message message = messageAndOffset.message();
            CompressionCodec compressionCodec = message.compressionCodec();
            NoCompressionCodec$ noCompressionCodec$ = NoCompressionCodec$.MODULE$;
            CompressionCodec compressionCodec2 = compressionCodec;
            IteratorTemplate<MessageAndOffset> iteratorTemplate2 = !(noCompressionCodec$ != null ? !noCompressionCodec$.equals(compressionCodec2) : compressionCodec2 != null) ? this.getSingleMessageIterator(messageAndOffset) : ByteBufferMessageSet$.MODULE$.decompress(message).iterator();
            iteratorTemplate = iteratorTemplate2;
        } else {
            iteratorTemplate = this.getSingleMessageIterator(messageAndOffset);
        }
        return iteratorTemplate;
    }

    private IteratorTemplate<MessageAndOffset> getSingleMessageIterator(MessageAndOffset messageAndOffset) {
        return new IteratorTemplate<MessageAndOffset>(messageAndOffset){
            private boolean messageIterated;
            private final MessageAndOffset messageAndOffset$1;

            public boolean messageIterated() {
                return this.messageIterated;
            }

            public void messageIterated_$eq(boolean x$1) {
                this.messageIterated = x$1;
            }

            public MessageAndOffset makeNext() {
                MessageAndOffset messageAndOffset;
                if (this.messageIterated()) {
                    messageAndOffset = (MessageAndOffset)this.allDone();
                } else {
                    this.messageIterated_$eq(true);
                    messageAndOffset = this.messageAndOffset$1;
                }
                return messageAndOffset;
            }
            {
                this.messageAndOffset$1 = messageAndOffset$1;
                this.messageIterated = false;
            }
        };
    }

    private DumpLogSegments$() {
        MODULE$ = this;
    }
}

