/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.tools;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.doxia.site.Body;
import org.apache.maven.doxia.site.Image;
import org.apache.maven.doxia.site.LinkItem;
import org.apache.maven.doxia.site.Menu;
import org.apache.maven.doxia.site.PublishDate;
import org.apache.maven.doxia.site.SiteModel;
import org.apache.maven.doxia.site.Skin;
import org.apache.maven.doxia.site.Version;
import org.apache.maven.doxia.site.decoration.Banner;
import org.apache.maven.doxia.site.decoration.DecorationModel;
import org.apache.maven.doxia.site.decoration.Logo;
import org.apache.maven.doxia.site.decoration.MenuItem;
import org.apache.maven.doxia.site.decoration.io.xpp3.DecorationXpp3Reader;
import org.apache.maven.doxia.site.inheritance.SiteModelInheritanceAssembler;
import org.apache.maven.doxia.site.io.xpp3.SiteXpp3Reader;
import org.apache.maven.doxia.site.io.xpp3.SiteXpp3Writer;
import org.apache.maven.doxia.tools.SiteTool;
import org.apache.maven.doxia.tools.SiteToolException;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.MavenReport;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.plexus.interpolation.EnvarBasedValueSource;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.InterpolationPostProcessor;
import org.codehaus.plexus.interpolation.MapBasedValueSource;
import org.codehaus.plexus.interpolation.PrefixedObjectValueSource;
import org.codehaus.plexus.interpolation.PrefixedPropertiesValueSource;
import org.codehaus.plexus.interpolation.RegexBasedInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.LocalArtifactRequest;
import org.eclipse.aether.repository.LocalArtifactResult;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.transfer.ArtifactNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named
public class DefaultSiteTool
implements SiteTool {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSiteTool.class);
    @Inject
    protected RepositorySystem repositorySystem;
    @Inject
    private ArtifactHandlerManager artifactHandlerManager;
    @Inject
    protected I18N i18n;
    @Inject
    protected SiteModelInheritanceAssembler assembler;

    @Override
    public Artifact getSkinArtifactFromRepository(RepositorySystemSession repoSession, List<RemoteRepository> remoteProjectRepositories, Skin skin) throws SiteToolException {
        Objects.requireNonNull(repoSession, "repoSession cannot be null");
        Objects.requireNonNull(remoteProjectRepositories, "remoteProjectRepositories cannot be null");
        Objects.requireNonNull(skin, "skin cannot be null");
        String version = skin.getVersion();
        try {
            if (version == null) {
                version = "RELEASE";
            }
            VersionRange versionSpec = VersionRange.createFromVersionSpec((String)version);
            String type = "jar";
            DefaultArtifact artifact = new DefaultArtifact(skin.getGroupId(), skin.getArtifactId(), versionSpec, "runtime", type, null, this.artifactHandlerManager.getArtifactHandler(type));
            ArtifactRequest request = new ArtifactRequest(RepositoryUtils.toArtifact((Artifact)artifact), remoteProjectRepositories, "remote-skin");
            ArtifactResult result = this.repositorySystem.resolveArtifact(repoSession, request);
            return RepositoryUtils.toArtifact((org.eclipse.aether.artifact.Artifact)result.getArtifact());
        }
        catch (InvalidVersionSpecificationException e) {
            throw new SiteToolException("The skin version '" + version + "' is not valid", (Exception)((Object)e));
        }
        catch (ArtifactResolutionException e) {
            if (e.getCause() instanceof ArtifactNotFoundException) {
                throw new SiteToolException("The skin does not exist", e.getCause());
            }
            throw new SiteToolException("Unable to find skin", (Exception)((Object)e));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Deprecated
    public String getRelativePath(String to, String from) {
        String fromScheme;
        String toScheme;
        Objects.requireNonNull(to, "to cannot be null");
        Objects.requireNonNull(from, "from cannot be null");
        if (to.contains(":") && from.contains(":") && !(toScheme = to.substring(0, to.lastIndexOf(58))).equals(fromScheme = from.substring(0, from.lastIndexOf(58)))) {
            return to;
        }
        URL toUrl = null;
        URL fromUrl = null;
        String toPath = to;
        String fromPath = from;
        try {
            toUrl = new URL(to);
        }
        catch (MalformedURLException e) {
            try {
                toUrl = new File(DefaultSiteTool.getNormalizedPath(to)).toURI().toURL();
            }
            catch (MalformedURLException e1) {
                LOGGER.warn("Unable to load a URL for '" + to + "'", (Throwable)e);
                return to;
            }
        }
        try {
            fromUrl = new URL(from);
        }
        catch (MalformedURLException e) {
            try {
                fromUrl = new File(DefaultSiteTool.getNormalizedPath(from)).toURI().toURL();
            }
            catch (MalformedURLException e1) {
                LOGGER.warn("Unable to load a URL for '" + from + "'", (Throwable)e);
                return to;
            }
        }
        if (toUrl != null && fromUrl != null) {
            if (!toUrl.getProtocol().equalsIgnoreCase(fromUrl.getProtocol()) || !toUrl.getHost().equalsIgnoreCase(fromUrl.getHost()) || toUrl.getPort() != fromUrl.getPort()) return to;
            toPath = toUrl.getFile();
            fromPath = fromUrl.getFile();
        } else if (toUrl != null && fromUrl == null || toUrl == null && fromUrl != null) {
            return to;
        }
        String relativePath = DefaultSiteTool.getRelativeFilePath(fromPath, toPath);
        if (relativePath == null) {
            relativePath = to;
        }
        if (!LOGGER.isDebugEnabled() || relativePath.toString().equals(to)) return relativePath;
        LOGGER.debug("Mapped url: " + to + " to relative path: " + relativePath);
        return relativePath;
    }

    private static String getRelativeFilePath(String oldPath, String newPath) {
        String fromPath = new File(oldPath).getPath();
        String toPath = new File(newPath).getPath();
        if (toPath.matches("^\\[a-zA-Z]:")) {
            toPath = toPath.substring(1);
        }
        if (fromPath.matches("^\\[a-zA-Z]:")) {
            fromPath = fromPath.substring(1);
        }
        if (fromPath.startsWith(":", 1)) {
            fromPath = Character.toLowerCase(fromPath.charAt(0)) + fromPath.substring(1);
        }
        if (toPath.startsWith(":", 1)) {
            toPath = Character.toLowerCase(toPath.charAt(0)) + toPath.substring(1);
        }
        if (toPath.startsWith(":", 1) && fromPath.startsWith(":", 1) && !toPath.substring(0, 1).equals(fromPath.substring(0, 1))) {
            return null;
        }
        if (toPath.startsWith(":", 1) && !fromPath.startsWith(":", 1) || !toPath.startsWith(":", 1) && fromPath.startsWith(":", 1)) {
            return null;
        }
        String relativePath = DefaultSiteTool.buildRelativePath(toPath, fromPath, File.separatorChar);
        return relativePath.toString();
    }

    @Override
    public File getSiteDescriptor(File siteDirectory, Locale locale) {
        Objects.requireNonNull(siteDirectory, "siteDirectory cannot be null");
        Objects.requireNonNull(locale, "locale cannot be null");
        String variant = locale.getVariant();
        String country = locale.getCountry();
        String language = locale.getLanguage();
        File siteDescriptor = null;
        if (!variant.isEmpty()) {
            siteDescriptor = new File(siteDirectory, "site_" + language + "_" + country + "_" + variant + ".xml");
        }
        if (!(siteDescriptor != null && siteDescriptor.isFile() || country.isEmpty())) {
            siteDescriptor = new File(siteDirectory, "site_" + language + "_" + country + ".xml");
        }
        if (!(siteDescriptor != null && siteDescriptor.isFile() || language.isEmpty())) {
            siteDescriptor = new File(siteDirectory, "site_" + language + ".xml");
        }
        if (siteDescriptor == null || !siteDescriptor.isFile()) {
            siteDescriptor = new File(siteDirectory, "site.xml");
        }
        return siteDescriptor;
    }

    File getSiteDescriptorFromRepository(MavenProject project, RepositorySystemSession repoSession, List<RemoteRepository> remoteProjectRepositories, Locale locale) throws SiteToolException {
        Objects.requireNonNull(project, "project cannot be null");
        Objects.requireNonNull(repoSession, "repoSession cannot be null");
        Objects.requireNonNull(remoteProjectRepositories, "remoteProjectRepositories cannot be null");
        Objects.requireNonNull(locale, "locale cannot be null");
        try {
            File siteDescriptor = this.resolveSiteDescriptor(project, repoSession, remoteProjectRepositories, locale);
            if (siteDescriptor == null) {
                LOGGER.debug("Site descriptor not found");
                return null;
            }
            return siteDescriptor;
        }
        catch (ArtifactResolutionException e) {
            throw new SiteToolException("Unable to locate site descriptor", (Exception)((Object)e));
        }
    }

    @Override
    public SiteModel getSiteModel(File siteDirectory, Locale locale, MavenProject project, List<MavenProject> reactorProjects, RepositorySystemSession repoSession, List<RemoteRepository> remoteProjectRepositories) throws SiteToolException {
        Objects.requireNonNull(locale, "locale cannot be null");
        Objects.requireNonNull(project, "project cannot be null");
        Objects.requireNonNull(reactorProjects, "reactorProjects cannot be null");
        Objects.requireNonNull(repoSession, "repoSession cannot be null");
        Objects.requireNonNull(remoteProjectRepositories, "remoteProjectRepositories cannot be null");
        LOGGER.debug("Computing site model of '" + project.getId() + "' for " + (locale.equals(SiteTool.DEFAULT_LOCALE) ? "default locale" : "locale '" + locale + "'"));
        Map.Entry<SiteModel, MavenProject> result = this.getSiteModel(0, siteDirectory, locale, project, repoSession, remoteProjectRepositories);
        SiteModel siteModel = result.getKey();
        MavenProject parentProject = result.getValue();
        if (siteModel == null) {
            LOGGER.debug("Using default site descriptor");
            siteModel = this.getDefaultSiteModel();
        }
        String siteDescriptorContent = this.siteModelToString(siteModel);
        siteDescriptorContent = this.getInterpolatedSiteDescriptorContent(project, siteDescriptorContent, false);
        siteModel = this.readSiteModel(siteDescriptorContent, project, locale);
        if (parentProject != null) {
            this.populateParentMenu(siteModel, locale, project, parentProject, true);
        }
        try {
            this.populateModulesMenu(siteModel, locale, project, reactorProjects, true);
        }
        catch (IOException e) {
            throw new SiteToolException("Error while populating modules menu", e);
        }
        return siteModel;
    }

    @Override
    public String getInterpolatedSiteDescriptorContent(Map<String, String> props, MavenProject aProject, String siteDescriptorContent) throws SiteToolException {
        Objects.requireNonNull(props, "props cannot be null");
        return this.getInterpolatedSiteDescriptorContent(aProject, siteDescriptorContent, false);
    }

    private String getInterpolatedSiteDescriptorContent(MavenProject aProject, String siteDescriptorContent, boolean isEarly) throws SiteToolException {
        Objects.requireNonNull(aProject, "aProject cannot be null");
        Objects.requireNonNull(siteDescriptorContent, "siteDescriptorContent cannot be null");
        RegexBasedInterpolator interpolator = new RegexBasedInterpolator();
        if (isEarly) {
            interpolator.addValueSource((ValueSource)new PrefixedObjectValueSource("this.", (Object)aProject));
            interpolator.addValueSource((ValueSource)new PrefixedPropertiesValueSource("this.", aProject.getProperties()));
        } else {
            interpolator.addValueSource((ValueSource)new PrefixedObjectValueSource("project.", (Object)aProject));
            interpolator.addValueSource((ValueSource)new MapBasedValueSource((Map)aProject.getProperties()));
            try {
                interpolator.addValueSource((ValueSource)new EnvarBasedValueSource());
            }
            catch (IOException e) {
                throw new SiteToolException("Cannot interpolate environment properties", e);
            }
        }
        interpolator.addPostProcessor(new InterpolationPostProcessor(){

            public Object execute(String expression, Object value) {
                if (value != null) {
                    return value.toString().replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&apos;");
                }
                return null;
            }
        });
        try {
            return interpolator.interpolate(siteDescriptorContent);
        }
        catch (InterpolationException e) {
            throw new SiteToolException("Cannot interpolate site descriptor", (Exception)((Object)e));
        }
    }

    private void populateParentMenu(SiteModel siteModel, Locale locale, MavenProject project, MavenProject parentProject, boolean keepInheritedRefs) {
        Objects.requireNonNull(siteModel, "siteModel cannot be null");
        Objects.requireNonNull(locale, "locale cannot be null");
        Objects.requireNonNull(project, "project cannot be null");
        Objects.requireNonNull(parentProject, "parentProject cannot be null");
        Menu menu = siteModel.getMenuRef("parent");
        if (menu == null) {
            return;
        }
        if (keepInheritedRefs && menu.isInheritAsRef()) {
            return;
        }
        String parentUrl = DefaultSiteTool.getDistMgmntSiteUrl(parentProject);
        if (parentUrl != null) {
            parentUrl = parentUrl.endsWith("/") ? parentUrl + "index.html" : parentUrl + "/index.html";
            parentUrl = this.getRelativePath(parentUrl, DefaultSiteTool.getDistMgmntSiteUrl(project));
        } else {
            File parentBasedir = parentProject.getBasedir();
            if (parentBasedir != null) {
                String parentPath = parentBasedir.getAbsolutePath();
                String projectPath = project.getBasedir().getAbsolutePath();
                parentUrl = this.getRelativePath(parentPath, projectPath) + "/index.html";
            }
        }
        if (parentUrl == null) {
            LOGGER.warn("Unable to find a URL to the parent project. The parent menu will NOT be added.");
        } else {
            if (menu.getName() == null) {
                menu.setName(this.i18n.getString("site-tool", locale, "siteModel.menu.parentproject"));
            }
            org.apache.maven.doxia.site.MenuItem item = new org.apache.maven.doxia.site.MenuItem();
            item.setName(parentProject.getName());
            item.setHref(parentUrl);
            menu.addItem(item);
        }
    }

    private void populateModulesMenu(SiteModel siteModel, Locale locale, MavenProject project, List<MavenProject> reactorProjects, boolean keepInheritedRefs) throws SiteToolException, IOException {
        Objects.requireNonNull(siteModel, "siteModel cannot be null");
        Objects.requireNonNull(locale, "locale cannot be null");
        Objects.requireNonNull(project, "project cannot be null");
        Objects.requireNonNull(reactorProjects, "reactorProjects cannot be null");
        Menu menu = siteModel.getMenuRef("modules");
        if (menu == null) {
            return;
        }
        if (keepInheritedRefs && menu.isInheritAsRef()) {
            return;
        }
        if (!project.getModules().isEmpty()) {
            if (menu.getName() == null) {
                menu.setName(this.i18n.getString("site-tool", locale, "siteModel.menu.projectmodules"));
            }
            for (String module : project.getModules()) {
                MavenProject moduleProject = this.getModuleFromReactor(project, reactorProjects, module);
                if (moduleProject == null) {
                    LOGGER.debug("Module " + module + " not found in reactor");
                    continue;
                }
                String pluginId = "org.apache.maven.plugins:maven-site-plugin";
                String skipFlag = DefaultSiteTool.getPluginParameter(moduleProject, "org.apache.maven.plugins:maven-site-plugin", "skip");
                if (skipFlag == null) {
                    skipFlag = moduleProject.getProperties().getProperty("maven.site.skip");
                }
                String siteUrl = "true".equalsIgnoreCase(skipFlag) ? null : DefaultSiteTool.getDistMgmntSiteUrl(moduleProject);
                String itemName = moduleProject.getName() == null ? moduleProject.getArtifactId() : moduleProject.getName();
                String defaultSiteUrl = "true".equalsIgnoreCase(skipFlag) ? null : moduleProject.getArtifactId();
                this.appendMenuItem(project, menu, itemName, siteUrl, defaultSiteUrl);
            }
        } else if (siteModel.getMenuRef("modules").getInherit() == null) {
            siteModel.removeMenuRef("modules");
        }
    }

    private MavenProject getModuleFromReactor(MavenProject project, List<MavenProject> reactorProjects, String module) throws IOException {
        File moduleBasedir = new File(project.getBasedir(), module).getCanonicalFile();
        for (MavenProject reactorProject : reactorProjects) {
            if (!moduleBasedir.equals(reactorProject.getBasedir())) continue;
            return reactorProject;
        }
        return null;
    }

    @Override
    public void populateReportsMenu(SiteModel siteModel, Locale locale, Map<String, List<MavenReport>> categories) {
        Objects.requireNonNull(siteModel, "siteModel cannot be null");
        Objects.requireNonNull(locale, "locale cannot be null");
        Objects.requireNonNull(categories, "categories cannot be null");
        Menu menu = siteModel.getMenuRef("reports");
        if (menu == null) {
            return;
        }
        if (menu.getName() == null) {
            menu.setName(this.i18n.getString("site-tool", locale, "siteModel.menu.projectdocumentation"));
        }
        boolean found = false;
        if (menu.getItems().isEmpty()) {
            org.apache.maven.doxia.site.MenuItem item;
            List<MavenReport> categoryReports = categories.get("Project Info");
            if (!DefaultSiteTool.isEmptyList(categoryReports)) {
                item = this.createCategoryMenu(this.i18n.getString("site-tool", locale, "siteModel.menu.projectinformation"), "/project-info.html", categoryReports, locale);
                menu.getItems().add(item);
                found = true;
            }
            if (!DefaultSiteTool.isEmptyList(categoryReports = categories.get("Project Reports"))) {
                item = this.createCategoryMenu(this.i18n.getString("site-tool", locale, "siteModel.menu.projectreports"), "/project-reports.html", categoryReports, locale);
                menu.getItems().add(item);
                found = true;
            }
        }
        if (!found) {
            siteModel.removeMenuRef("reports");
        }
    }

    @Override
    public List<Locale> getSiteLocales(String locales) {
        if (locales == null) {
            return Collections.singletonList(DEFAULT_LOCALE);
        }
        String[] localesArray = StringUtils.split((String)locales, (String)",");
        List<Locale> localesList = new ArrayList<Locale>(localesArray.length);
        List<Locale> availableLocales = Arrays.asList(Locale.getAvailableLocales());
        for (String localeString : localesArray) {
            Locale locale = this.codeToLocale(localeString);
            if (locale == null) continue;
            if (!availableLocales.contains(locale)) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn("The locale defined by '" + locale + "' is not available in this Java Virtual Machine (" + System.getProperty("java.version") + " from " + System.getProperty("java.vendor") + ") - IGNORING");
                continue;
            }
            Locale bundleLocale = this.i18n.getBundle("site-tool", locale).getLocale();
            if (!bundleLocale.equals(locale) && !bundleLocale.getLanguage().equals(locale.getLanguage())) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn("The locale '" + locale + "' (" + locale.getDisplayName(Locale.ENGLISH) + ") is not currently supported by Maven Site - IGNORING." + System.lineSeparator() + "Contributions are welcome and greatly appreciated!" + System.lineSeparator() + "If you want to contribute a new translation, please visit https://maven.apache.org/plugins/localization.html for detailed instructions.");
                continue;
            }
            localesList.add(locale);
        }
        if (localesList.isEmpty()) {
            localesList = Collections.singletonList(DEFAULT_LOCALE);
        }
        return localesList;
    }

    private Locale codeToLocale(String localeCode) {
        if (localeCode == null) {
            return null;
        }
        if ("system".equalsIgnoreCase(localeCode)) {
            return Locale.getDefault();
        }
        if ("default".equalsIgnoreCase(localeCode)) {
            return SiteTool.DEFAULT_LOCALE;
        }
        String language = "";
        String country = "";
        String variant = "";
        StringTokenizer tokenizer = new StringTokenizer(localeCode, "_");
        int maxTokens = 3;
        if (tokenizer.countTokens() > 3) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Invalid java.util.Locale format for '" + localeCode + "' entry - IGNORING");
            }
            return null;
        }
        if (tokenizer.hasMoreTokens()) {
            language = tokenizer.nextToken();
            if (tokenizer.hasMoreTokens()) {
                country = tokenizer.nextToken();
                if (tokenizer.hasMoreTokens()) {
                    variant = tokenizer.nextToken();
                }
            }
        }
        return new Locale(language, country, variant);
    }

    protected static String getNormalizedPath(String path) {
        String normalized = FilenameUtils.normalize((String)path);
        if (normalized == null) {
            normalized = path;
        }
        return normalized == null ? null : normalized.replace('\\', '/');
    }

    private ArtifactRequest createSiteDescriptorArtifactRequest(MavenProject project, String localeStr, List<RemoteRepository> remoteProjectRepositories) {
        String type = "xml";
        ArtifactHandler artifactHandler = this.artifactHandlerManager.getArtifactHandler(type);
        DefaultArtifact artifact = new DefaultArtifact(project.getGroupId(), project.getArtifactId(), project.getVersion(), "runtime", type, "site" + (localeStr.isEmpty() ? "" : "_" + localeStr), artifactHandler);
        return new ArtifactRequest(RepositoryUtils.toArtifact((Artifact)artifact), remoteProjectRepositories, "remote-site-descriptor");
    }

    private File resolveSiteDescriptor(MavenProject project, RepositorySystemSession repoSession, List<RemoteRepository> remoteProjectRepositories, Locale locale) throws ArtifactResolutionException {
        ArtifactResult result;
        ArtifactRequest request;
        String variant = locale.getVariant();
        String country = locale.getCountry();
        String language = locale.getLanguage();
        String localeStr = null;
        File siteDescriptor = null;
        boolean found = false;
        if (!variant.isEmpty()) {
            localeStr = language + "_" + country + "_" + variant;
            request = this.createSiteDescriptorArtifactRequest(project, localeStr, remoteProjectRepositories);
            this.deletePseudoSiteDescriptorMarkerFile(repoSession, request);
            try {
                result = this.repositorySystem.resolveArtifact(repoSession, request);
                siteDescriptor = result.getArtifact().getFile();
                found = true;
            }
            catch (ArtifactResolutionException e) {
                if (e.getResult().getExceptions().stream().anyMatch(re -> re instanceof ArtifactNotFoundException)) {
                    LOGGER.debug("No site descriptor found for '" + project.getId() + "' for locale '" + localeStr + "', trying without variant...");
                }
                throw e;
            }
        }
        if (!found && !country.isEmpty()) {
            localeStr = language + "_" + country;
            request = this.createSiteDescriptorArtifactRequest(project, localeStr, remoteProjectRepositories);
            this.deletePseudoSiteDescriptorMarkerFile(repoSession, request);
            try {
                result = this.repositorySystem.resolveArtifact(repoSession, request);
                siteDescriptor = result.getArtifact().getFile();
                found = true;
            }
            catch (ArtifactResolutionException e) {
                if (e.getResult().getExceptions().stream().anyMatch(re -> re instanceof ArtifactNotFoundException)) {
                    LOGGER.debug("No site descriptor found for '" + project.getId() + "' for locale '" + localeStr + "', trying without country...");
                }
                throw e;
            }
        }
        if (!found && !language.isEmpty()) {
            localeStr = language;
            request = this.createSiteDescriptorArtifactRequest(project, localeStr, remoteProjectRepositories);
            this.deletePseudoSiteDescriptorMarkerFile(repoSession, request);
            try {
                result = this.repositorySystem.resolveArtifact(repoSession, request);
                siteDescriptor = result.getArtifact().getFile();
                found = true;
            }
            catch (ArtifactResolutionException e) {
                if (e.getResult().getExceptions().stream().anyMatch(re -> re instanceof ArtifactNotFoundException)) {
                    LOGGER.debug("No site descriptor found for '" + project.getId() + "' for locale '" + localeStr + "', trying without language (default locale)...");
                }
                throw e;
            }
        }
        if (!found) {
            localeStr = SiteTool.DEFAULT_LOCALE.toString();
            request = this.createSiteDescriptorArtifactRequest(project, localeStr, remoteProjectRepositories);
            this.deletePseudoSiteDescriptorMarkerFile(repoSession, request);
            try {
                result = this.repositorySystem.resolveArtifact(repoSession, request);
                siteDescriptor = result.getArtifact().getFile();
            }
            catch (ArtifactResolutionException e) {
                if (e.getResult().getExceptions().stream().anyMatch(re -> re instanceof ArtifactNotFoundException)) {
                    LOGGER.debug("No site descriptor found for '" + project.getId() + "' with default locale");
                    return null;
                }
                throw e;
            }
        }
        return siteDescriptor;
    }

    private void deletePseudoSiteDescriptorMarkerFile(RepositorySystemSession repoSession, ArtifactRequest request) {
        LocalRepositoryManager lrm = repoSession.getLocalRepositoryManager();
        LocalArtifactRequest localRequest = new LocalArtifactRequest(request.getArtifact(), request.getRepositories(), request.getRequestContext());
        LocalArtifactResult localResult = lrm.find(repoSession, localRequest);
        File localArtifactFile = localResult.getFile();
        try {
            if (localResult.isAvailable() && Files.size(localArtifactFile.toPath()) == 0L) {
                LOGGER.debug("Deleting 0-byte pseudo marker file for artifact '{}' at '{}'", (Object)localRequest.getArtifact(), (Object)localArtifactFile);
                Files.delete(localArtifactFile.toPath());
            }
        }
        catch (IOException e) {
            LOGGER.debug("Failed to delete 0-byte pseudo marker file for artifact '{}'", (Object)localRequest.getArtifact(), (Object)e);
        }
    }

    private Map.Entry<SiteModel, MavenProject> getSiteModel(int depth, File siteDirectory, Locale locale, MavenProject project, RepositorySystemSession repoSession, List<RemoteRepository> remoteProjectRepositories) throws SiteToolException {
        File siteDescriptor;
        if (project.getBasedir() == null) {
            try {
                siteDescriptor = this.getSiteDescriptorFromRepository(project, repoSession, remoteProjectRepositories, locale);
            }
            catch (SiteToolException e) {
                throw new SiteToolException("The site descriptor cannot be resolved from the repository", e);
            }
        } else {
            siteDescriptor = this.getSiteDescriptor(siteDirectory, locale);
        }
        SiteModel siteModel = null;
        XmlStreamReader siteDescriptorReader = null;
        try {
            if (siteDescriptor != null && siteDescriptor.exists()) {
                LOGGER.debug("Reading" + (depth == 0 ? "" : " parent level " + depth) + " site descriptor from " + siteDescriptor);
                siteDescriptorReader = ReaderFactory.newXmlReader((File)siteDescriptor);
                String siteDescriptorContent = IOUtil.toString((Reader)siteDescriptorReader);
                siteDescriptorContent = this.getInterpolatedSiteDescriptorContent(project, siteDescriptorContent, true);
                siteModel = this.readSiteModel(siteDescriptorContent, project, locale);
                siteModel.setLastModified(siteDescriptor.lastModified());
            } else {
                LOGGER.debug("No" + (depth == 0 ? "" : " parent level " + depth) + " site descriptor");
            }
        }
        catch (IOException e) {
            throw new SiteToolException("The site descriptor for '" + project.getId() + "' cannot be read from " + siteDescriptor, e);
        }
        finally {
            IOUtil.close(siteDescriptorReader);
        }
        MavenProject parentProject = project.getParent();
        if (parentProject != null && (siteModel == null || siteModel.isMergeParent() || siteModel.isRequireParent())) {
            LOGGER.debug("Looking for site descriptor of level " + ++depth + " parent project: " + parentProject.getId());
            File parentSiteDirectory = null;
            if (parentProject.getBasedir() != null) {
                String siteRelativePath = DefaultSiteTool.getRelativeFilePath(project.getBasedir().getAbsolutePath(), siteDescriptor.getParentFile().getAbsolutePath());
                parentSiteDirectory = new File(parentProject.getBasedir(), siteRelativePath);
            }
            SiteModel parentSiteModel = this.getSiteModel(depth, parentSiteDirectory, locale, parentProject, repoSession, remoteProjectRepositories).getKey();
            if (siteModel != null && siteModel.isRequireParent() && parentSiteModel == null) {
                throw new SiteToolException("The site descriptor for '" + project.getId() + "' requires a parent site descriptor for '" + parentProject.getId() + "' or any of its parents but none could be found!");
            }
            if (siteModel == null && parentSiteModel != null) {
                siteModel = new SiteModel();
            }
            String name = project.getName();
            if (siteModel != null && StringUtils.isNotEmpty((String)siteModel.getName())) {
                name = siteModel.getName();
            }
            String projectDistMgmnt = DefaultSiteTool.getDistMgmntSiteUrl(project);
            String parentDistMgmnt = DefaultSiteTool.getDistMgmntSiteUrl(parentProject);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Site model inheritance: assembling child with level " + depth + " parent: distributionManagement.site.url child = " + projectDistMgmnt + " and parent = " + parentDistMgmnt);
            }
            this.assembler.assembleModelInheritance(name, siteModel, parentSiteModel, projectDistMgmnt, parentDistMgmnt == null ? projectDistMgmnt : parentDistMgmnt);
        } else if (parentProject == null && siteModel != null && siteModel.isRequireParent()) {
            throw new SiteToolException("The site descriptor for '" + project.getId() + "' requires a parent site descriptor but no parent is defined in the POM.");
        }
        return new AbstractMap.SimpleEntry<Object, MavenProject>(siteModel, parentProject);
    }

    private SiteModel readSiteModel(String siteDescriptorContent, MavenProject project, Locale locale) throws SiteToolException {
        try {
            if (project != null && this.isOldSiteModel(siteDescriptorContent)) {
                LOGGER.warn("Site model of '" + project.getId() + "' for " + (locale.equals(SiteTool.DEFAULT_LOCALE) ? "default locale" : "locale '" + locale + "'") + " is still using the old pre-version 2.0.0 model. You MUST migrate to the new model as soon as possible otherwise your build will break in the future!");
                return this.convertOldToNewSiteModel(new DecorationXpp3Reader().read((Reader)new StringReader(siteDescriptorContent)));
            }
            return new SiteXpp3Reader().read((Reader)new StringReader(siteDescriptorContent));
        }
        catch (XmlPullParserException e) {
            throw new SiteToolException("Error parsing site descriptor", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new SiteToolException("Error reading site descriptor", e);
        }
    }

    private SiteModel convertOldToNewSiteModel(DecorationModel oldModel) {
        SiteModel newModel = new SiteModel();
        newModel.setName(oldModel.getName());
        newModel.setCombineSelf(oldModel.getCombineSelf());
        if (oldModel.getBannerLeft() != null) {
            newModel.setBannerLeft(this.convertBanner(oldModel.getBannerLeft()));
        }
        if (oldModel.getBannerRight() != null) {
            newModel.setBannerRight(this.convertBanner(oldModel.getBannerRight()));
        }
        if (!oldModel.isDefaultPublishDate()) {
            PublishDate newPublishDate = new PublishDate();
            newPublishDate.setFormat(oldModel.getPublishDate().getFormat());
            newPublishDate.setPosition(oldModel.getPublishDate().getPosition());
            newPublishDate.setTimezone(oldModel.getPublishDate().getTimezone());
            newModel.setPublishDate(newPublishDate);
        }
        if (!oldModel.isDefaultVersion()) {
            Version newVersion = new Version();
            newVersion.setPosition(oldModel.getVersion().getPosition());
            newModel.setVersion(newVersion);
        }
        newModel.setEdit(oldModel.getEdit());
        if (oldModel.getSkin() != null) {
            Skin newSkin = new Skin();
            newSkin.setGroupId(oldModel.getSkin().getGroupId());
            newSkin.setArtifactId(oldModel.getSkin().getArtifactId());
            newSkin.setVersion(oldModel.getSkin().getVersion());
            newModel.setSkin(newSkin);
        }
        for (Logo oldLogo : oldModel.getPoweredBy()) {
            org.apache.maven.doxia.site.Logo newLogo = new org.apache.maven.doxia.site.Logo();
            newLogo.setName(oldLogo.getName());
            newLogo.setHref(oldLogo.getHref());
            newLogo.setTarget(oldLogo.getTarget());
            if (oldLogo.getImg() != null) {
                newLogo.setImage(this.convertImage(oldLogo.getImg(), oldLogo.getPosition(), oldLogo.getHeight(), oldLogo.getWidth(), oldLogo.getBorder(), oldLogo.getAlt()));
            }
            newModel.addPoweredBy(newLogo);
        }
        newModel.setLastModified(oldModel.getLastModified());
        if (oldModel.getBody() != null) {
            Body newBody = new Body();
            newBody.setHead(oldModel.getBody().getHead());
            for (org.apache.maven.doxia.site.decoration.LinkItem oldLink : oldModel.getBody().getLinks()) {
                newBody.addLink(this.convertLinkItem(oldLink));
            }
            for (org.apache.maven.doxia.site.decoration.LinkItem oldBreadcrumb : oldModel.getBody().getBreadcrumbs()) {
                newBody.addBreadcrumb(this.convertLinkItem(oldBreadcrumb));
            }
            for (org.apache.maven.doxia.site.decoration.Menu oldMenu : oldModel.getBody().getMenus()) {
                Menu newMenu = new Menu();
                newMenu.setName(oldMenu.getName());
                newMenu.setInherit(oldMenu.getInherit());
                newMenu.setInheritAsRef(oldMenu.isInheritAsRef());
                newMenu.setRef(oldMenu.getRef());
                if (oldMenu.getImg() != null) {
                    newMenu.setImage(this.convertImage(oldMenu.getImg(), oldMenu.getPosition(), oldMenu.getHeight(), oldMenu.getWidth(), oldMenu.getBorder(), oldMenu.getAlt()));
                }
                newMenu.setItems(this.convertMenuItems(oldMenu.getItems()));
                newBody.addMenu(newMenu);
            }
            newBody.setFooter(oldModel.getBody().getFooter());
            newModel.setBody(newBody);
        }
        newModel.setCustom(oldModel.getCustom());
        return newModel;
    }

    private org.apache.maven.doxia.site.Banner convertBanner(Banner oldBanner) {
        org.apache.maven.doxia.site.Banner newBanner = new org.apache.maven.doxia.site.Banner();
        newBanner.setName(oldBanner.getName());
        newBanner.setHref(oldBanner.getHref());
        if (oldBanner.getSrc() != null) {
            newBanner.setImage(this.convertImage(oldBanner.getSrc(), null, oldBanner.getHeight(), oldBanner.getWidth(), oldBanner.getBorder(), oldBanner.getAlt()));
        }
        return newBanner;
    }

    private Image convertImage(String src, String position, String height, String width, String border, String alt) {
        Image newImage = new Image();
        newImage.setSrc(src);
        newImage.setPosition(position);
        newImage.setHeight(height);
        newImage.setWidth(width);
        if (border != null) {
            newImage.setStyle("border: " + border + ";");
        }
        newImage.setAlt(alt);
        return newImage;
    }

    private LinkItem convertLinkItem(org.apache.maven.doxia.site.decoration.LinkItem oldLinkItem) {
        LinkItem newLinkItem = new LinkItem();
        newLinkItem.setName(oldLinkItem.getName());
        newLinkItem.setHref(oldLinkItem.getHref());
        newLinkItem.setTarget(oldLinkItem.getTarget());
        if (oldLinkItem.getImg() != null) {
            newLinkItem.setImage(this.convertImage(oldLinkItem.getImg(), oldLinkItem.getPosition(), oldLinkItem.getHeight(), oldLinkItem.getWidth(), oldLinkItem.getBorder(), oldLinkItem.getAlt()));
        }
        return newLinkItem;
    }

    private List<org.apache.maven.doxia.site.MenuItem> convertMenuItems(List<MenuItem> oldMenuItems) {
        ArrayList<org.apache.maven.doxia.site.MenuItem> newMenuItems = new ArrayList<org.apache.maven.doxia.site.MenuItem>();
        for (MenuItem oldMenuItem : oldMenuItems) {
            org.apache.maven.doxia.site.MenuItem newMenuItem = new org.apache.maven.doxia.site.MenuItem();
            newMenuItem.setName(oldMenuItem.getName());
            newMenuItem.setHref(oldMenuItem.getHref());
            newMenuItem.setTarget(oldMenuItem.getTarget());
            newMenuItem.setCollapse(oldMenuItem.isCollapse());
            newMenuItem.setRef(oldMenuItem.getRef());
            newMenuItem.setItems(this.convertMenuItems(oldMenuItem.getItems()));
            if (oldMenuItem.getImg() != null) {
                newMenuItem.setImage(this.convertImage(oldMenuItem.getImg(), oldMenuItem.getPosition(), oldMenuItem.getHeight(), oldMenuItem.getWidth(), oldMenuItem.getBorder(), oldMenuItem.getAlt()));
            }
            newMenuItems.add(newMenuItem);
        }
        return newMenuItems;
    }

    private boolean isOldSiteModel(String siteDescriptorContent) throws XmlPullParserException, IOException {
        MXParser parser = new MXParser();
        parser.setInput((Reader)new StringReader(siteDescriptorContent));
        if (parser.getEventType() != 0 || parser.next() != 2) {
            return false;
        }
        return "project".equals(parser.getName());
    }

    private SiteModel getDefaultSiteModel() throws SiteToolException {
        String siteDescriptorContent;
        XmlStreamReader reader = null;
        try {
            reader = ReaderFactory.newXmlReader((InputStream)this.getClass().getResourceAsStream("/default-site.xml"));
            siteDescriptorContent = IOUtil.toString((Reader)reader);
        }
        catch (IOException e) {
            try {
                throw new SiteToolException("Error reading default site descriptor", e);
            }
            catch (Throwable throwable) {
                IOUtil.close(reader);
                throw throwable;
            }
        }
        IOUtil.close((Reader)reader);
        return this.readSiteModel(siteDescriptorContent, null, SiteTool.DEFAULT_LOCALE);
    }

    private String siteModelToString(SiteModel siteModel) throws SiteToolException {
        StringWriter writer = new StringWriter();
        try {
            new SiteXpp3Writer().write((Writer)writer, siteModel);
            String string = writer.toString();
            return string;
        }
        catch (IOException e) {
            throw new SiteToolException("Error reading site descriptor", e);
        }
        finally {
            IOUtil.close((Writer)writer);
        }
    }

    private static String buildRelativePath(String toPath, String fromPath, char separatorChar) {
        StringTokenizer toTokeniser = new StringTokenizer(toPath, String.valueOf(separatorChar));
        StringTokenizer fromTokeniser = new StringTokenizer(fromPath, String.valueOf(separatorChar));
        int count = 0;
        while (toTokeniser.hasMoreTokens() && fromTokeniser.hasMoreTokens() && !(separatorChar == '\\' ? !fromTokeniser.nextToken().equalsIgnoreCase(toTokeniser.nextToken()) : !fromTokeniser.nextToken().equals(toTokeniser.nextToken()))) {
            ++count;
        }
        toTokeniser = new StringTokenizer(toPath, String.valueOf(separatorChar));
        fromTokeniser = new StringTokenizer(fromPath, String.valueOf(separatorChar));
        while (count-- > 0) {
            fromTokeniser.nextToken();
            toTokeniser.nextToken();
        }
        StringBuilder relativePath = new StringBuilder();
        while (fromTokeniser.hasMoreTokens()) {
            fromTokeniser.nextToken();
            relativePath.append("..");
            if (!fromTokeniser.hasMoreTokens()) continue;
            relativePath.append(separatorChar);
        }
        if (relativePath.length() != 0 && toTokeniser.hasMoreTokens()) {
            relativePath.append(separatorChar);
        }
        while (toTokeniser.hasMoreTokens()) {
            relativePath.append(toTokeniser.nextToken());
            if (!toTokeniser.hasMoreTokens()) continue;
            relativePath.append(separatorChar);
        }
        return relativePath.toString();
    }

    private void appendMenuItem(MavenProject project, Menu menu, String name, String href, String defaultHref) {
        String selectedHref = href;
        if (selectedHref == null) {
            selectedHref = defaultHref;
        }
        org.apache.maven.doxia.site.MenuItem item = new org.apache.maven.doxia.site.MenuItem();
        item.setName(name);
        if (selectedHref != null) {
            String baseUrl = DefaultSiteTool.getDistMgmntSiteUrl(project);
            if (baseUrl != null) {
                selectedHref = this.getRelativePath(selectedHref, baseUrl);
            }
            if (selectedHref.endsWith("/")) {
                item.setHref(selectedHref + "index.html");
            } else {
                item.setHref(selectedHref + "/index.html");
            }
        }
        menu.addItem(item);
    }

    private org.apache.maven.doxia.site.MenuItem createCategoryMenu(String name, String href, List<MavenReport> categoryReports, Locale locale) {
        org.apache.maven.doxia.site.MenuItem item = new org.apache.maven.doxia.site.MenuItem();
        item.setName(name);
        item.setCollapse(true);
        item.setHref(href);
        for (MavenReport report : categoryReports) {
            org.apache.maven.doxia.site.MenuItem subitem = new org.apache.maven.doxia.site.MenuItem();
            subitem.setName(report.getName(locale));
            subitem.setHref(report.getOutputName() + ".html");
            item.getItems().add(subitem);
        }
        return item;
    }

    private static boolean isEmptyList(List<?> list) {
        return list == null || list.isEmpty();
    }

    private static String getDistMgmntSiteUrl(MavenProject project) {
        return DefaultSiteTool.getDistMgmntSiteUrl(project.getDistributionManagement());
    }

    private static String getDistMgmntSiteUrl(DistributionManagement distMgmnt) {
        if (distMgmnt != null && distMgmnt.getSite() != null && distMgmnt.getSite().getUrl() != null) {
            return DefaultSiteTool.urlEncode(distMgmnt.getSite().getUrl());
        }
        return null;
    }

    private static Plugin getPlugin(MavenProject project, String pluginId) {
        if (project.getBuild() == null || project.getBuild().getPluginsAsMap() == null) {
            return null;
        }
        Plugin plugin = (Plugin)project.getBuild().getPluginsAsMap().get(pluginId);
        if (plugin == null && project.getBuild().getPluginManagement() != null && project.getBuild().getPluginManagement().getPluginsAsMap() != null) {
            plugin = (Plugin)project.getBuild().getPluginManagement().getPluginsAsMap().get(pluginId);
        }
        return plugin;
    }

    private static String getPluginParameter(MavenProject project, String pluginId, String param) {
        Xpp3Dom xpp3Dom;
        Plugin plugin = DefaultSiteTool.getPlugin(project, pluginId);
        if (plugin != null && (xpp3Dom = (Xpp3Dom)plugin.getConfiguration()) != null && xpp3Dom.getChild(param) != null && StringUtils.isNotEmpty((String)xpp3Dom.getChild(param).getValue())) {
            return xpp3Dom.getChild(param).getValue();
        }
        return null;
    }

    private static String urlEncode(String url) {
        if (url == null) {
            return null;
        }
        try {
            return new File(url).toURI().toURL().toExternalForm();
        }
        catch (MalformedURLException ex) {
            return url;
        }
    }
}

