/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.shade.relocation;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.maven.plugins.shade.relocation.Relocator;
import org.codehaus.plexus.util.SelectorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleRelocator
implements Relocator {
    private final String pattern;
    private final String pathPattern;
    private final String shadedPattern;
    private final String shadedPathPattern;
    private final Set<String> includes;
    private final Set<String> excludes;
    private final boolean rawString;

    public SimpleRelocator(String patt, String shadedPattern, List<String> includes, List<String> excludes) {
        this(patt, shadedPattern, includes, excludes, false);
    }

    public SimpleRelocator(String patt, String shadedPattern, List<String> includes, List<String> excludes, boolean rawString) {
        this.rawString = rawString;
        if (rawString) {
            this.pathPattern = patt;
            this.shadedPathPattern = shadedPattern;
            this.pattern = null;
            this.shadedPattern = null;
        } else {
            if (patt == null) {
                this.pattern = "";
                this.pathPattern = "";
            } else {
                this.pattern = patt.replace('/', '.');
                this.pathPattern = patt.replace('.', '/');
            }
            if (shadedPattern != null) {
                this.shadedPattern = shadedPattern.replace('/', '.');
                this.shadedPathPattern = shadedPattern.replace('.', '/');
            } else {
                this.shadedPattern = "hidden." + this.pattern;
                this.shadedPathPattern = "hidden/" + this.pathPattern;
            }
        }
        this.includes = SimpleRelocator.normalizePatterns(includes);
        this.excludes = SimpleRelocator.normalizePatterns(excludes);
    }

    private static Set<String> normalizePatterns(Collection<String> patterns) {
        LinkedHashSet<String> normalized = null;
        if (patterns != null && !patterns.isEmpty()) {
            normalized = new LinkedHashSet<String>();
            for (String pattern : patterns) {
                String classPattern = pattern.replace('.', '/');
                normalized.add(classPattern);
                if (!classPattern.endsWith("/*")) continue;
                String packagePattern = classPattern.substring(0, classPattern.lastIndexOf(47));
                normalized.add(packagePattern);
            }
        }
        return normalized;
    }

    private boolean isIncluded(String path) {
        if (this.includes != null && !this.includes.isEmpty()) {
            for (String include : this.includes) {
                if (!SelectorUtils.matchPath((String)include, (String)path, (boolean)true)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean isExcluded(String path) {
        if (this.excludes != null && !this.excludes.isEmpty()) {
            for (String exclude : this.excludes) {
                if (!SelectorUtils.matchPath((String)exclude, (String)path, (boolean)true)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canRelocatePath(String path) {
        if (this.rawString) {
            return Pattern.compile(this.pathPattern).matcher(path).find();
        }
        if (path.endsWith(".class")) {
            path = path.substring(0, path.length() - 6);
        }
        if (!this.isIncluded(path) || this.isExcluded(path)) {
            return false;
        }
        return path.startsWith(this.pathPattern);
    }

    @Override
    public boolean canRelocateClass(String clazz) {
        return !this.rawString && clazz.indexOf(47) < 0 && this.canRelocatePath(clazz.replace('.', '/'));
    }

    @Override
    public String relocatePath(String path) {
        if (this.rawString) {
            return path.replaceAll(this.pathPattern, this.shadedPathPattern);
        }
        return path.replaceFirst(this.pathPattern, this.shadedPathPattern);
    }

    @Override
    public String relocateClass(String clazz) {
        return clazz.replaceFirst(this.pattern, this.shadedPattern);
    }
}

