/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.clearcase.command.remove;

import java.io.File;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.remove.AbstractRemoveCommand;
import org.apache.maven.scm.command.status.StatusScmResult;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.clearcase.command.ClearCaseCommand;
import org.apache.maven.scm.provider.clearcase.command.edit.ClearCaseEditCommand;
import org.apache.maven.scm.provider.clearcase.command.remove.ClearCaseRemoveConsumer;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class ClearCaseRemoveCommand
extends AbstractRemoveCommand
implements ClearCaseCommand {
    protected ScmResult executeRemoveCommand(ScmProviderRepository scmProviderRepository, ScmFileSet scmFileSet, String string) throws ScmException {
        int exitCode;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("executing remove command...");
        }
        Commandline cl = ClearCaseRemoveCommand.createCommandLine(this.getLogger(), scmFileSet);
        ClearCaseRemoveConsumer consumer = new ClearCaseRemoveConsumer(this.getLogger());
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        try {
            Commandline checkoutCurrentDirCommandLine = ClearCaseEditCommand.createCheckoutCurrentDirCommandLine(scmFileSet);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Executing: " + checkoutCurrentDirCommandLine.getWorkingDirectory().getAbsolutePath() + ">>" + checkoutCurrentDirCommandLine.toString());
            }
            if ((exitCode = CommandLineUtils.executeCommandLine((Commandline)checkoutCurrentDirCommandLine, (StreamConsumer)new CommandLineUtils.StringStreamConsumer(), (StreamConsumer)stderr)) == 0) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Executing: " + cl.getWorkingDirectory().getAbsolutePath() + ">>" + cl.toString());
                }
                if ((exitCode = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)consumer, (StreamConsumer)stderr)) == 0) {
                    Commandline checkinCurrentDirCommandLine = ClearCaseEditCommand.createCheckinCurrentDirCommandLine(scmFileSet);
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Executing: " + checkinCurrentDirCommandLine.getWorkingDirectory().getAbsolutePath() + ">>" + checkinCurrentDirCommandLine.toString());
                    }
                    exitCode = CommandLineUtils.executeCommandLine((Commandline)checkinCurrentDirCommandLine, (StreamConsumer)new CommandLineUtils.StringStreamConsumer(), (StreamConsumer)stderr);
                }
            }
        }
        catch (CommandLineException ex) {
            throw new ScmException("Error while executing clearcase command.", (Throwable)ex);
        }
        if (exitCode != 0) {
            return new StatusScmResult(cl.toString(), "The cleartool command failed.", stderr.getOutput(), false);
        }
        return new StatusScmResult(cl.toString(), consumer.getRemovedFiles());
    }

    public static Commandline createCommandLine(ScmLogger logger, ScmFileSet scmFileSet) {
        Commandline command = new Commandline();
        File workingDirectory = scmFileSet.getBasedir();
        command.setWorkingDirectory(workingDirectory.getAbsolutePath());
        command.setExecutable("cleartool");
        command.createArg().setValue("rmname");
        command.createArg().setValue("-nc");
        File[] files = scmFileSet.getFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (logger.isInfoEnabled()) {
                logger.info("Deleting file: " + file.getAbsolutePath());
            }
            command.createArg().setValue(file.getName());
        }
        return command;
    }
}

