/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.jazz.command.list;

import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.list.AbstractListCommand;
import org.apache.maven.scm.command.list.ListScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.jazz.command.JazzScmCommand;
import org.apache.maven.scm.provider.jazz.command.consumer.ErrorConsumer;
import org.apache.maven.scm.provider.jazz.command.list.JazzListConsumer;
import org.apache.maven.scm.provider.jazz.repository.JazzScmProviderRepository;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class JazzListCommand
extends AbstractListCommand {
    protected ListScmResult executeListCommand(ScmProviderRepository repo, ScmFileSet fileSet, boolean recursive, ScmVersion version) throws ScmException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Executing list command...");
        }
        JazzScmProviderRepository jazzRepo = (JazzScmProviderRepository)repo;
        JazzListConsumer listConsumer = new JazzListConsumer(repo, this.getLogger());
        ErrorConsumer errConsumer = new ErrorConsumer(this.getLogger());
        JazzScmCommand listCmd = this.createListCommand(jazzRepo, fileSet, recursive, version);
        int status = listCmd.execute((StreamConsumer)listConsumer, errConsumer);
        if (status != 0) {
            return new ListScmResult(listCmd.getCommandString(), "Error code for Jazz SCM list command - " + status, errConsumer.getOutput(), false);
        }
        return new ListScmResult(listCmd.getCommandString(), listConsumer.getFiles());
    }

    public JazzScmCommand createListCommand(JazzScmProviderRepository repo, ScmFileSet fileSet, boolean recursive, ScmVersion version) {
        JazzScmCommand command = new JazzScmCommand("list", "remotefiles", (ScmProviderRepository)repo, fileSet, this.getLogger());
        if (recursive) {
            command.addArgument("--depth");
            command.addArgument("-");
        }
        command.addArgument(repo.getRepositoryWorkspace());
        command.addArgument(repo.getComponent());
        return command;
    }
}

