/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.transfer.project.deploy.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Hex;
import org.codehaus.plexus.util.IOUtil;

class DualDigester {
    private final MessageDigest md5 = DualDigester.getDigester("MD5");
    private final MessageDigest sh1 = DualDigester.getDigester("SHA-1");
    private static final int BUFSIZE = 131072;
    private final byte[] buffer = new byte[131072];

    DualDigester() {
    }

    static MessageDigest getDigester(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Unable to initialize digest " + algorithm + " : " + e.getMessage());
        }
    }

    public void calculate(File file) throws IOException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            this.calculate(fis);
            fis.close();
            fis = null;
        }
        catch (IOException e) {
            try {
                throw new IOException("Failed to calculate digest checksum for " + file, e);
            }
            catch (Throwable throwable) {
                IOUtil.close(fis);
                throw throwable;
            }
        }
        IOUtil.close((InputStream)fis);
    }

    void calculate(InputStream stream) throws IOException {
        this.md5.reset();
        this.sh1.reset();
        this.update(stream);
    }

    public String getMd5() {
        return Hex.encodeHexString((byte[])this.md5.digest());
    }

    public String getSha1() {
        return Hex.encodeHexString((byte[])this.sh1.digest());
    }

    private void update(InputStream is) throws IOException {
        int size = is.read(this.buffer, 0, 131072);
        while (size >= 0) {
            this.md5.update(this.buffer, 0, size);
            this.sh1.update(this.buffer, 0, size);
            size = is.read(this.buffer, 0, 131072);
        }
    }
}

