/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.booterclient.output;

import org.apache.maven.surefire.util.internal.BlockingQueue;
import org.apache.maven.surefire.util.internal.BlockingQueueFactory;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class ThreadedStreamConsumer
implements StreamConsumer {
    private final BlockingQueue items = BlockingQueueFactory.createBlockingQueue();
    private static final String poison = "Pioson";
    private final Thread thread;
    private final Pumper pumper;

    public ThreadedStreamConsumer(StreamConsumer target) {
        this.pumper = new Pumper(this.items, target);
        this.thread = new Thread((Runnable)this.pumper, "ThreadedStreamConsumer");
        this.thread.start();
    }

    public void consumeLine(String s) {
        this.items.add((Object)s);
    }

    public void close() {
        try {
            this.items.add((Object)poison);
            this.thread.join();
            if (this.pumper.getInterruptedException() != null) {
                throw this.pumper.getInterruptedException();
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    static class Pumper
    implements Runnable {
        private final BlockingQueue queue;
        private final StreamConsumer target;
        private volatile InterruptedException interruptedException;

        Pumper(BlockingQueue queue, StreamConsumer target) {
            this.queue = queue;
            this.target = target;
        }

        public void run() {
            try {
                String item = (String)this.queue.take();
                while (item != ThreadedStreamConsumer.poison) {
                    this.target.consumeLine(item);
                    item = (String)this.queue.take();
                }
            }
            catch (InterruptedException e) {
                this.interruptedException = e;
            }
        }

        public InterruptedException getInterruptedException() {
            return this.interruptedException;
        }
    }
}

