/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.report;

import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import org.apache.maven.plugin.surefire.report.TestcycleConsoleOutputReceiver;
import org.apache.maven.surefire.report.ReportEntry;

public class DirectConsoleOutput
implements TestcycleConsoleOutputReceiver {
    private final PrintStream sout;
    private final PrintStream serr;

    public DirectConsoleOutput(PrintStream sout, PrintStream serr) {
        this.sout = sout;
        this.serr = serr;
    }

    public void writeTestOutput(byte[] buf, int off, int len, boolean stdout) {
        PrintStream stream = stdout ? this.sout : this.serr;
        try {
            CharBuffer decode = Charset.defaultCharset().newDecoder().decode(ByteBuffer.wrap(buf, off, len));
            stream.append(decode);
        }
        catch (CharacterCodingException e) {
            stream.write(buf, off, len);
        }
    }

    public void testSetStarting(ReportEntry reportEntry) {
    }

    public void testSetCompleted(ReportEntry report) {
    }

    public void close() {
    }
}

