/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.booter;

import java.io.DataInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.maven.surefire.booter.Command;

public enum MasterProcessCommand {
    RUN_CLASS(0, String.class),
    TEST_SET_FINISHED(1, Void.class),
    SKIP_SINCE_NEXT_TEST(2, Void.class),
    SHUTDOWN(3, String.class),
    NOOP(4, Void.class),
    BYE_ACK(5, Void.class);

    private final int id;
    private final Class<?> dataType;

    private MasterProcessCommand(int id, Class<?> dataType) {
        this.id = id;
        this.dataType = Objects.requireNonNull(dataType, "dataType cannot be null");
    }

    public int getId() {
        return this.id;
    }

    public Class<?> getDataType() {
        return this.dataType;
    }

    public boolean hasDataType() {
        return this.dataType != Void.class;
    }

    public byte[] encode(String data) {
        if (!this.hasDataType()) {
            throw new IllegalArgumentException("cannot use data without data type");
        }
        if (this.getDataType() != String.class) {
            throw new IllegalArgumentException("Data type can be only " + String.class);
        }
        byte[] dataBytes = this.fromDataType(data);
        int len = dataBytes.length;
        byte[] encoded = new byte[8 + len];
        int command = this.getId();
        MasterProcessCommand.setCommandAndDataLength(command, len, encoded);
        System.arraycopy(dataBytes, 0, encoded, 8, len);
        return encoded;
    }

    public byte[] encode() {
        if (this.getDataType() != Void.class) {
            throw new IllegalArgumentException("Data type can be only " + this.getDataType());
        }
        byte[] encoded = new byte[8];
        int command = this.getId();
        MasterProcessCommand.setCommandAndDataLength(command, 0, encoded);
        return encoded;
    }

    public static Command decode(DataInputStream is) throws IOException {
        MasterProcessCommand command = MasterProcessCommand.resolve(is.readInt());
        if (command == null) {
            return null;
        }
        int dataLength = is.readInt();
        if (dataLength > 0) {
            byte[] buffer = new byte[dataLength];
            is.readFully(buffer);
            if (command.getDataType() == Void.class) {
                throw new IOException(String.format("Command %s unexpectedly read Void data with length %d.", new Object[]{command, dataLength}));
            }
            String data = command.toDataTypeAsString(buffer);
            return new Command(command, data);
        }
        return new Command(command);
    }

    String toDataTypeAsString(byte ... data) {
        switch (this) {
            case RUN_CLASS: 
            case SHUTDOWN: {
                return new String(data, StandardCharsets.US_ASCII);
            }
        }
        return null;
    }

    byte[] fromDataType(String data) {
        switch (this) {
            case RUN_CLASS: 
            case SHUTDOWN: {
                return data.getBytes(StandardCharsets.US_ASCII);
            }
        }
        return new byte[0];
    }

    static MasterProcessCommand resolve(int id) {
        for (MasterProcessCommand command : MasterProcessCommand.values()) {
            if (id != command.id) continue;
            return command;
        }
        return null;
    }

    static void setCommandAndDataLength(int command, int dataLength, byte ... encoded) {
        encoded[0] = (byte)(command >>> 24);
        encoded[1] = (byte)(command >>> 16);
        encoded[2] = (byte)(command >>> 8);
        encoded[3] = (byte)command;
        encoded[4] = (byte)(dataLength >>> 24);
        encoded[5] = (byte)(dataLength >>> 16);
        encoded[6] = (byte)(dataLength >>> 8);
        encoded[7] = (byte)dataLength;
    }
}

