/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.booter;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.maven.surefire.booter.AbstractPathConfiguration;
import org.apache.maven.surefire.booter.BaseProviderFactory;
import org.apache.maven.surefire.booter.BooterDeserializer;
import org.apache.maven.surefire.booter.ClasspathConfiguration;
import org.apache.maven.surefire.booter.Command;
import org.apache.maven.surefire.booter.CommandListener;
import org.apache.maven.surefire.booter.CommandReader;
import org.apache.maven.surefire.booter.DumpErrorSingleton;
import org.apache.maven.surefire.booter.ForkingReporterFactory;
import org.apache.maven.surefire.booter.ForkingRunListener;
import org.apache.maven.surefire.booter.LazyTestsToRun;
import org.apache.maven.surefire.booter.PpidChecker;
import org.apache.maven.surefire.booter.ProviderConfiguration;
import org.apache.maven.surefire.booter.Shutdown;
import org.apache.maven.surefire.booter.StartupConfiguration;
import org.apache.maven.surefire.booter.SurefireExecutionException;
import org.apache.maven.surefire.booter.SystemPropertyManager;
import org.apache.maven.surefire.booter.TypeEncodedValue;
import org.apache.maven.surefire.providerapi.ProviderParameters;
import org.apache.maven.surefire.providerapi.SurefireProvider;
import org.apache.maven.surefire.report.LegacyPojoStackTraceWriter;
import org.apache.maven.surefire.report.ReporterFactory;
import org.apache.maven.surefire.report.StackTraceWriter;
import org.apache.maven.surefire.suite.RunResult;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.apache.maven.surefire.util.ReflectionUtils;
import org.apache.maven.surefire.util.internal.DaemonThreadFactory;
import org.apache.maven.surefire.util.internal.StringUtils;

public final class ForkedBooter {
    private static final long DEFAULT_SYSTEM_EXIT_TIMEOUT_IN_SECONDS = 30L;
    private static final long PING_TIMEOUT_IN_SECONDS = 30L;
    private static final long ONE_SECOND_IN_MILLIS = 1000L;
    private static final String LAST_DITCH_SHUTDOWN_THREAD = "surefire-forkedjvm-last-ditch-daemon-shutdown-thread-";
    private static final String PING_THREAD = "surefire-forkedjvm-ping-";
    private final CommandReader commandReader = CommandReader.getReader();
    private final PrintStream originalOut = System.out;
    private volatile long systemExitTimeoutInSeconds = 30L;
    private volatile PingScheduler pingScheduler;
    private ScheduledThreadPoolExecutor jvmTerminator;
    private ProviderConfiguration providerConfiguration;
    private StartupConfiguration startupConfiguration;
    private Object testSet;

    private void setupBooter(String tmpDir, String dumpFileName, String surefirePropsFileName, String effectiveSystemPropertiesFileName) throws IOException {
        BooterDeserializer booterDeserializer = new BooterDeserializer(ForkedBooter.createSurefirePropertiesIfFileExists(tmpDir, surefirePropsFileName));
        this.pingScheduler = ForkedBooter.isDebugging() ? null : this.listenToShutdownCommands(booterDeserializer.getPluginPid());
        SystemPropertyManager.setSystemProperties(new File(tmpDir, effectiveSystemPropertiesFileName));
        this.providerConfiguration = booterDeserializer.deserialize();
        DumpErrorSingleton.getSingleton().init(this.providerConfiguration.getReporterConfiguration().getReportsDirectory(), dumpFileName);
        this.startupConfiguration = booterDeserializer.getProviderConfiguration();
        this.systemExitTimeoutInSeconds = this.providerConfiguration.systemExitTimeout(30L);
        AbstractPathConfiguration classpathConfiguration = this.startupConfiguration.getClasspathConfiguration();
        if (classpathConfiguration.isClassPathConfig()) {
            if (this.startupConfiguration.isManifestOnlyJarRequestedAndUsable()) {
                classpathConfiguration.toRealPath(ClasspathConfiguration.class).trickClassPathWhenManifestOnlyClasspath();
            }
            this.startupConfiguration.writeSurefireTestClasspathProperty();
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        classLoader.setDefaultAssertionStatus(classpathConfiguration.isEnableAssertions());
        boolean readTestsFromCommandReader = this.providerConfiguration.isReadTestsFromInStream();
        this.testSet = this.createTestSet(this.providerConfiguration.getTestForFork(), readTestsFromCommandReader, classLoader);
    }

    private void execute() {
        try {
            this.runSuitesInProcess();
        }
        catch (InvocationTargetException t) {
            DumpErrorSingleton.getSingleton().dumpException((Throwable)t);
            LegacyPojoStackTraceWriter stackTraceWriter = new LegacyPojoStackTraceWriter("test subsystem", "no method", t.getTargetException());
            StringBuilder stringBuilder = new StringBuilder();
            ForkingRunListener.encode((StringBuilder)stringBuilder, (StackTraceWriter)stackTraceWriter, (boolean)false);
            this.encodeAndWriteToOutput("X,0," + stringBuilder + "\n");
        }
        catch (Throwable t) {
            DumpErrorSingleton.getSingleton().dumpException(t);
            LegacyPojoStackTraceWriter stackTraceWriter = new LegacyPojoStackTraceWriter("test subsystem", "no method", t);
            StringBuilder stringBuilder = new StringBuilder();
            ForkingRunListener.encode((StringBuilder)stringBuilder, (StackTraceWriter)stackTraceWriter, (boolean)false);
            this.encodeAndWriteToOutput("X,0," + stringBuilder + "\n");
        }
        this.acknowledgedExit();
    }

    private Object createTestSet(TypeEncodedValue forkedTestSet, boolean readTestsFromCommandReader, ClassLoader cl) {
        if (forkedTestSet != null) {
            return forkedTestSet.getDecodedValue(cl);
        }
        if (readTestsFromCommandReader) {
            return new LazyTestsToRun(this.originalOut);
        }
        return null;
    }

    private void cancelPingScheduler() {
        if (this.pingScheduler != null) {
            try {
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        ForkedBooter.this.pingScheduler.shutdown();
                        return null;
                    }
                });
            }
            catch (AccessControlException accessControlException) {
                // empty catch block
            }
        }
    }

    private PingScheduler listenToShutdownCommands(Long ppid) {
        this.commandReader.addShutdownListener(this.createExitHandler());
        AtomicBoolean pingDone = new AtomicBoolean(true);
        this.commandReader.addNoopListener(this.createPingHandler(pingDone));
        PingScheduler pingMechanisms = new PingScheduler(ForkedBooter.createPingScheduler(), ppid == null ? null : new PpidChecker(ppid));
        if (pingMechanisms.pluginProcessChecker != null) {
            Runnable checkerJob = this.processCheckerJob(pingMechanisms);
            pingMechanisms.pingScheduler.scheduleWithFixedDelay(checkerJob, 0L, 1L, TimeUnit.SECONDS);
        }
        Runnable pingJob = this.createPingJob(pingDone, pingMechanisms.pluginProcessChecker);
        pingMechanisms.pingScheduler.scheduleAtFixedRate(pingJob, 0L, 30L, TimeUnit.SECONDS);
        return pingMechanisms;
    }

    private Runnable processCheckerJob(final PingScheduler pingMechanism) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    if (pingMechanism.pluginProcessChecker.canUse() && !pingMechanism.pluginProcessChecker.isProcessAlive() && !pingMechanism.pingScheduler.isShutdown()) {
                        DumpErrorSingleton.getSingleton().dumpText("Killing self fork JVM. Maven process died.");
                        ForkedBooter.this.kill();
                    }
                }
                catch (RuntimeException e) {
                    DumpErrorSingleton.getSingleton().dumpException((Throwable)e, "System.exit() or native command error interrupted process checker.");
                }
            }
        };
    }

    private CommandListener createPingHandler(final AtomicBoolean pingDone) {
        return new CommandListener(){

            public void update(Command command) {
                pingDone.set(true);
            }
        };
    }

    private CommandListener createExitHandler() {
        return new CommandListener(){

            public void update(Command command) {
                Shutdown shutdown = command.toShutdownData();
                if (shutdown.isKill()) {
                    DumpErrorSingleton.getSingleton().dumpText("Killing self fork JVM. Received SHUTDOWN command from Maven shutdown hook.");
                    ForkedBooter.this.kill();
                } else if (shutdown.isExit()) {
                    ForkedBooter.this.cancelPingScheduler();
                    DumpErrorSingleton.getSingleton().dumpText("Exiting self fork JVM. Received SHUTDOWN command from Maven shutdown hook.");
                    ForkedBooter.this.exit(1);
                }
            }
        };
    }

    private Runnable createPingJob(final AtomicBoolean pingDone, final PpidChecker pluginProcessChecker) {
        return new Runnable(){

            @Override
            public void run() {
                boolean hasPing;
                if (!ForkedBooter.canUseNewPingMechanism(pluginProcessChecker) && !(hasPing = pingDone.getAndSet(false))) {
                    DumpErrorSingleton.getSingleton().dumpText("Killing self fork JVM. PING timeout elapsed.");
                    ForkedBooter.this.kill();
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void encodeAndWriteToOutput(String string) {
        byte[] encodeBytes = StringUtils.encodeStringForForkCommunication((String)string);
        PrintStream printStream = this.originalOut;
        synchronized (printStream) {
            this.originalOut.write(encodeBytes, 0, encodeBytes.length);
            this.originalOut.flush();
        }
    }

    private void kill() {
        this.kill(1);
    }

    private void kill(int returnCode) {
        this.commandReader.stop();
        Runtime.getRuntime().halt(returnCode);
    }

    private void exit(int returnCode) {
        this.launchLastDitchDaemonShutdownThread(returnCode);
        System.exit(returnCode);
    }

    private void acknowledgedExit() {
        final Semaphore barrier = new Semaphore(0);
        this.commandReader.addByeAckListener(new CommandListener(){

            public void update(Command command) {
                barrier.release();
            }
        });
        this.encodeAndWriteToOutput("Z,0,BYE!\n");
        this.launchLastDitchDaemonShutdownThread(0);
        long timeoutMillis = Math.max(this.systemExitTimeoutInSeconds * 1000L, 1000L);
        ForkedBooter.acquireOnePermit(barrier, timeoutMillis);
        this.cancelPingScheduler();
        this.commandReader.stop();
        System.exit(0);
    }

    private RunResult runSuitesInProcess() throws SurefireExecutionException, TestSetFailedException, InvocationTargetException {
        ForkingReporterFactory factory = this.createForkingReporterFactory();
        return this.invokeProviderInSameClassLoader(factory);
    }

    private ForkingReporterFactory createForkingReporterFactory() {
        boolean trimStackTrace = this.providerConfiguration.getReporterConfiguration().isTrimStackTrace();
        return new ForkingReporterFactory(trimStackTrace, this.originalOut);
    }

    private synchronized ScheduledThreadPoolExecutor getJvmTerminator() {
        if (this.jvmTerminator == null) {
            ThreadFactory threadFactory = DaemonThreadFactory.newDaemonThreadFactory((String)(LAST_DITCH_SHUTDOWN_THREAD + this.systemExitTimeoutInSeconds + "s"));
            this.jvmTerminator = new ScheduledThreadPoolExecutor(1, threadFactory);
            this.jvmTerminator.setMaximumPoolSize(1);
        }
        return this.jvmTerminator;
    }

    private void launchLastDitchDaemonShutdownThread(final int returnCode) {
        this.getJvmTerminator().schedule(new Runnable(){

            @Override
            public void run() {
                ForkedBooter.this.kill(returnCode);
            }
        }, this.systemExitTimeoutInSeconds, TimeUnit.SECONDS);
    }

    private RunResult invokeProviderInSameClassLoader(ForkingReporterFactory factory) throws TestSetFailedException, InvocationTargetException {
        return this.createProviderInCurrentClassloader(factory).invoke(this.testSet);
    }

    private SurefireProvider createProviderInCurrentClassloader(ForkingReporterFactory reporterManagerFactory) {
        BaseProviderFactory bpf = new BaseProviderFactory((ReporterFactory)reporterManagerFactory, true);
        bpf.setTestRequest(this.providerConfiguration.getTestSuiteDefinition());
        bpf.setReporterConfiguration(this.providerConfiguration.getReporterConfiguration());
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        bpf.setClassLoaders(classLoader);
        bpf.setTestArtifactInfo(this.providerConfiguration.getTestArtifact());
        bpf.setProviderProperties(this.providerConfiguration.getProviderProperties());
        bpf.setRunOrderParameters(this.providerConfiguration.getRunOrderParameters());
        bpf.setDirectoryScannerParameters(this.providerConfiguration.getDirScannerParams());
        bpf.setMainCliOptions(this.providerConfiguration.getMainCliOptions());
        bpf.setSkipAfterFailureCount(this.providerConfiguration.getSkipAfterFailureCount());
        bpf.setShutdown(this.providerConfiguration.getShutdown());
        bpf.setSystemExitTimeout(this.providerConfiguration.getSystemExitTimeout());
        String providerClass = this.startupConfiguration.getActualClassName();
        return (SurefireProvider)ReflectionUtils.instantiateOneArg((ClassLoader)classLoader, (String)providerClass, ProviderParameters.class, (Object)bpf);
    }

    public static void main(String ... args) {
        ForkedBooter booter = new ForkedBooter();
        try {
            booter.setupBooter(args[0], args[1], args[2], args.length > 3 ? args[3] : null);
            booter.execute();
        }
        catch (Throwable t) {
            DumpErrorSingleton.getSingleton().dumpException(t);
            t.printStackTrace();
            booter.cancelPingScheduler();
            booter.exit(1);
        }
    }

    private static boolean canUseNewPingMechanism(PpidChecker pluginProcessChecker) {
        return pluginProcessChecker != null && pluginProcessChecker.canUse();
    }

    private static boolean acquireOnePermit(Semaphore barrier, long timeoutMillis) {
        try {
            return barrier.tryAcquire(timeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            return true;
        }
    }

    private static ScheduledExecutorService createPingScheduler() {
        ThreadFactory threadFactory = DaemonThreadFactory.newDaemonThreadFactory((String)"surefire-forkedjvm-ping-30s");
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, threadFactory);
        executor.setKeepAliveTime(3L, TimeUnit.SECONDS);
        executor.setMaximumPoolSize(2);
        return executor;
    }

    private static InputStream createSurefirePropertiesIfFileExists(String tmpDir, String propFileName) throws FileNotFoundException {
        File surefirePropertiesFile = new File(tmpDir, propFileName);
        return surefirePropertiesFile.exists() ? new FileInputStream(surefirePropertiesFile) : null;
    }

    private static boolean isDebugging() {
        for (String argument : ManagementFactory.getRuntimeMXBean().getInputArguments()) {
            if (!"-Xdebug".equals(argument) && !argument.startsWith("-agentlib:jdwp")) continue;
            return true;
        }
        return false;
    }

    private static class PingScheduler {
        private final ScheduledExecutorService pingScheduler;
        private final PpidChecker pluginProcessChecker;

        PingScheduler(ScheduledExecutorService pingScheduler, PpidChecker pluginProcessChecker) {
            this.pingScheduler = pingScheduler;
            this.pluginProcessChecker = pluginProcessChecker;
        }

        void shutdown() {
            this.pingScheduler.shutdown();
            if (this.pluginProcessChecker != null) {
                this.pluginProcessChecker.destroyActiveCommands();
            }
        }

        boolean isShutdown() {
            return this.pingScheduler.isShutdown();
        }
    }
}

