/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.binder.metadata.schema;

import com.google.common.collect.Lists;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.sql.parser.binder.metadata.column.ColumnMetaDataLoader;
import org.apache.shardingsphere.sql.parser.binder.metadata.index.IndexMetaDataLoader;
import org.apache.shardingsphere.sql.parser.binder.metadata.schema.SchemaMetaData;
import org.apache.shardingsphere.sql.parser.binder.metadata.table.TableMetaData;
import org.apache.shardingsphere.sql.parser.binder.metadata.util.JdbcUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SchemaMetaDataLoader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger((String)"ShardingSphere-metadata");
    private static final String TABLE_TYPE = "TABLE";
    private static final String TABLE_NAME = "TABLE_NAME";

    public static SchemaMetaData load(DataSource dataSource, int maxConnectionCount, String databaseType) throws SQLException {
        List<String> tableNames;
        try (Connection connection = dataSource.getConnection();){
            tableNames = SchemaMetaDataLoader.loadAllTableNames(connection, databaseType);
        }
        log.info("Loading {} tables' meta data.", (Object)tableNames.size());
        if (0 == tableNames.size()) {
            return new SchemaMetaData(Collections.emptyMap());
        }
        List tableGroups = Lists.partition(tableNames, (int)Math.max(tableNames.size() / maxConnectionCount, 1));
        Map<String, TableMetaData> tableMetaDataMap = 1 == tableGroups.size() ? SchemaMetaDataLoader.load(dataSource.getConnection(), (Collection)tableGroups.get(0), databaseType) : SchemaMetaDataLoader.asyncLoad(dataSource, maxConnectionCount, tableNames, tableGroups, databaseType);
        return new SchemaMetaData(tableMetaDataMap);
    }

    private static Map<String, TableMetaData> load(Connection connection, Collection<String> tables, String databaseType) throws SQLException {
        try (Connection con = connection;){
            LinkedHashMap<String, TableMetaData> result = new LinkedHashMap<String, TableMetaData>();
            for (String each : tables) {
                result.put(each, new TableMetaData(ColumnMetaDataLoader.load(con, each, databaseType), IndexMetaDataLoader.load(con, each, databaseType)));
            }
            LinkedHashMap<String, TableMetaData> linkedHashMap = result;
            return linkedHashMap;
        }
    }

    private static List<String> loadAllTableNames(Connection connection, String databaseType) throws SQLException {
        LinkedList<String> result = new LinkedList<String>();
        try (ResultSet resultSet = connection.getMetaData().getTables(connection.getCatalog(), JdbcUtil.getSchema(connection, databaseType), null, new String[]{TABLE_TYPE});){
            while (resultSet.next()) {
                String table = resultSet.getString(TABLE_NAME);
                if (SchemaMetaDataLoader.isSystemTable(table)) continue;
                result.add(table);
            }
        }
        return result;
    }

    private static boolean isSystemTable(String table) {
        return table.contains("$") || table.contains("/");
    }

    private static Map<String, TableMetaData> asyncLoad(DataSource dataSource, int maxConnectionCount, List<String> tableNames, List<List<String>> tableGroups, String databaseType) throws SQLException {
        ConcurrentHashMap<String, TableMetaData> result = new ConcurrentHashMap<String, TableMetaData>(tableNames.size(), 1.0f);
        ExecutorService executorService = Executors.newFixedThreadPool(Math.min(tableGroups.size(), maxConnectionCount));
        LinkedList<Future<Map>> futures = new LinkedList<Future<Map>>();
        for (List<String> list : tableGroups) {
            futures.add(executorService.submit(() -> SchemaMetaDataLoader.load(dataSource.getConnection(), each, databaseType)));
        }
        for (Future future : futures) {
            try {
                result.putAll((Map)future.get());
            }
            catch (InterruptedException | ExecutionException ex) {
                if (ex.getCause() instanceof SQLException) {
                    throw (SQLException)ex.getCause();
                }
                Thread.currentThread().interrupt();
            }
        }
        return result;
    }

    @Generated
    private SchemaMetaDataLoader() {
    }
}

