/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.binder.segment.select.projection.engine;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import org.apache.shardingsphere.sql.parser.binder.metadata.schema.SchemaMetaData;
import org.apache.shardingsphere.sql.parser.binder.segment.select.groupby.GroupByContext;
import org.apache.shardingsphere.sql.parser.binder.segment.select.orderby.OrderByContext;
import org.apache.shardingsphere.sql.parser.binder.segment.select.orderby.OrderByItem;
import org.apache.shardingsphere.sql.parser.binder.segment.select.projection.DerivedColumn;
import org.apache.shardingsphere.sql.parser.binder.segment.select.projection.Projection;
import org.apache.shardingsphere.sql.parser.binder.segment.select.projection.ProjectionsContext;
import org.apache.shardingsphere.sql.parser.binder.segment.select.projection.engine.ProjectionEngine;
import org.apache.shardingsphere.sql.parser.binder.segment.select.projection.impl.DerivedProjection;
import org.apache.shardingsphere.sql.parser.binder.segment.select.projection.impl.ShorthandProjection;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.item.ProjectionsSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.order.item.ColumnOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.order.item.IndexOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.order.item.OrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.order.item.TextOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.statement.dml.SelectStatement;

public final class ProjectionsContextEngine {
    private final SchemaMetaData schemaMetaData;
    private final ProjectionEngine projectionEngine;

    public ProjectionsContextEngine(SchemaMetaData schemaMetaData) {
        this.schemaMetaData = schemaMetaData;
        this.projectionEngine = new ProjectionEngine(schemaMetaData);
    }

    public ProjectionsContext createProjectionsContext(String sql, SelectStatement selectStatement, GroupByContext groupByContext, OrderByContext orderByContext) {
        ProjectionsSegment projectionsSegment = selectStatement.getProjections();
        Collection<Projection> projections = this.getProjections(sql, selectStatement.getSimpleTableSegments(), projectionsSegment);
        ProjectionsContext result = new ProjectionsContext(projectionsSegment.getStartIndex(), projectionsSegment.getStopIndex(), projectionsSegment.isDistinctRow(), projections);
        result.getProjections().addAll(this.getDerivedGroupByColumns(projections, groupByContext, selectStatement));
        result.getProjections().addAll(this.getDerivedOrderByColumns(projections, orderByContext, selectStatement));
        return result;
    }

    private Collection<Projection> getProjections(String sql, Collection<SimpleTableSegment> tableSegments, ProjectionsSegment projectionsSegment) {
        LinkedList<Projection> result = new LinkedList<Projection>();
        for (ProjectionSegment each : projectionsSegment.getProjections()) {
            this.projectionEngine.createProjection(sql, tableSegments, each).ifPresent(result::add);
        }
        return result;
    }

    private Collection<Projection> getDerivedGroupByColumns(Collection<Projection> projections, GroupByContext groupByContext, SelectStatement selectStatement) {
        return this.getDerivedOrderColumns(projections, groupByContext.getItems(), DerivedColumn.GROUP_BY_ALIAS, selectStatement);
    }

    private Collection<Projection> getDerivedOrderByColumns(Collection<Projection> projections, OrderByContext orderByContext, SelectStatement selectStatement) {
        return this.getDerivedOrderColumns(projections, orderByContext.getItems(), DerivedColumn.ORDER_BY_ALIAS, selectStatement);
    }

    private Collection<Projection> getDerivedOrderColumns(Collection<Projection> projections, Collection<OrderByItem> orderItems, DerivedColumn derivedColumn, SelectStatement selectStatement) {
        LinkedList<Projection> result = new LinkedList<Projection>();
        int derivedColumnOffset = 0;
        for (OrderByItem each : orderItems) {
            if (this.containsProjection(projections, each.getSegment(), selectStatement)) continue;
            result.add(new DerivedProjection(((TextOrderByItemSegment)each.getSegment()).getText(), derivedColumn.getDerivedColumnAlias(derivedColumnOffset++)));
        }
        return result;
    }

    private boolean containsProjection(Collection<Projection> projections, OrderByItemSegment orderByItemSegment, SelectStatement selectStatement) {
        return orderByItemSegment instanceof IndexOrderByItemSegment || this.containsItemInShorthandProjection(projections, orderByItemSegment, selectStatement) || this.containsProjection(projections, orderByItemSegment);
    }

    private boolean containsProjection(Collection<Projection> projections, OrderByItemSegment orderItem) {
        for (Projection each : projections) {
            if (orderItem instanceof IndexOrderByItemSegment) {
                return true;
            }
            if (!this.isSameAlias(each, (TextOrderByItemSegment)orderItem) && !this.isSameQualifiedName(each, (TextOrderByItemSegment)orderItem)) continue;
            return true;
        }
        return false;
    }

    private boolean containsItemInShorthandProjection(Collection<Projection> projections, OrderByItemSegment orderByItemSegment, SelectStatement selectStatement) {
        return this.isUnqualifiedShorthandProjection(projections) || this.containsItemWithOwnerInShorthandProjections(projections, orderByItemSegment, selectStatement) || this.containsItemWithoutOwnerInShorthandProjections(projections, orderByItemSegment, selectStatement);
    }

    private boolean isUnqualifiedShorthandProjection(Collection<Projection> projections) {
        if (1 != projections.size()) {
            return false;
        }
        Projection projection = projections.iterator().next();
        return projection instanceof ShorthandProjection && !((ShorthandProjection)projection).getOwner().isPresent();
    }

    private boolean containsItemWithOwnerInShorthandProjections(Collection<Projection> projections, OrderByItemSegment orderItem, SelectStatement selectStatement) {
        return orderItem instanceof ColumnOrderByItemSegment && ((ColumnOrderByItemSegment)orderItem).getColumn().getOwner().isPresent() && this.findShorthandProjection(projections, ((OwnerSegment)((ColumnOrderByItemSegment)orderItem).getColumn().getOwner().get()).getIdentifier().getValue(), selectStatement).isPresent();
    }

    private Optional<ShorthandProjection> findShorthandProjection(Collection<Projection> projections, String tableNameOrAlias, SelectStatement selectStatement) {
        SimpleTableSegment tableSegment = this.find(tableNameOrAlias, selectStatement);
        for (Projection each : projections) {
            ShorthandProjection shorthandProjection;
            if (!(each instanceof ShorthandProjection) || !(shorthandProjection = (ShorthandProjection)each).getOwner().isPresent() || !this.find(shorthandProjection.getOwner().get(), selectStatement).getTableName().getIdentifier().getValue().equalsIgnoreCase(tableSegment.getTableName().getIdentifier().getValue())) continue;
            return Optional.of(shorthandProjection);
        }
        return Optional.empty();
    }

    private boolean containsItemWithoutOwnerInShorthandProjections(Collection<Projection> projections, OrderByItemSegment orderItem, SelectStatement selectStatement) {
        if (!(orderItem instanceof ColumnOrderByItemSegment)) {
            return false;
        }
        if (!((ColumnOrderByItemSegment)orderItem).getColumn().getOwner().isPresent()) {
            for (ShorthandProjection each : this.getQualifiedShorthandProjections(projections)) {
                if (!this.isSameProjection(each, (ColumnOrderByItemSegment)orderItem, selectStatement)) continue;
                return true;
            }
        }
        return false;
    }

    private Collection<ShorthandProjection> getQualifiedShorthandProjections(Collection<Projection> projections) {
        LinkedList<ShorthandProjection> result = new LinkedList<ShorthandProjection>();
        for (Projection each : projections) {
            if (!(each instanceof ShorthandProjection) || !((ShorthandProjection)each).getOwner().isPresent()) continue;
            result.add((ShorthandProjection)each);
        }
        return result;
    }

    private boolean isSameProjection(ShorthandProjection shorthandProjection, ColumnOrderByItemSegment orderItem, SelectStatement selectStatement) {
        Preconditions.checkState((boolean)shorthandProjection.getOwner().isPresent());
        SimpleTableSegment tableSegment = this.find(shorthandProjection.getOwner().get(), selectStatement);
        return this.schemaMetaData.containsColumn(tableSegment.getTableName().getIdentifier().getValue(), orderItem.getColumn().getIdentifier().getValue());
    }

    private boolean isSameAlias(Projection projection, TextOrderByItemSegment orderItem) {
        return projection.getAlias().isPresent() && (orderItem.getText().equalsIgnoreCase(projection.getAlias().get()) || orderItem.getText().equalsIgnoreCase(projection.getExpression()));
    }

    private boolean isSameQualifiedName(Projection projection, TextOrderByItemSegment orderItem) {
        return !projection.getAlias().isPresent() && projection.getExpression().equalsIgnoreCase(orderItem.getText());
    }

    private SimpleTableSegment find(String tableNameOrAlias, SelectStatement selectStatement) {
        for (SimpleTableSegment each : selectStatement.getSimpleTableSegments()) {
            if (!tableNameOrAlias.equalsIgnoreCase(each.getTableName().getIdentifier().getValue()) && !tableNameOrAlias.equals(each.getAlias().orElse(null))) continue;
            return each;
        }
        throw new IllegalStateException("Can not find owner from table.");
    }
}

