/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.annotations;

import java.lang.reflect.Method;
import org.apache.hivemind.Location;
import org.apache.tapestry.annotations.AnnotationUtils;
import org.apache.tapestry.annotations.InitialValue;
import org.apache.tapestry.annotations.MethodAnnotationEnhancementWorker;
import org.apache.tapestry.annotations.Persist;
import org.apache.tapestry.engine.IPropertySource;
import org.apache.tapestry.enhance.EnhancementOperation;
import org.apache.tapestry.spec.IComponentSpecification;
import org.apache.tapestry.spec.IPropertySpecification;
import org.apache.tapestry.spec.PropertySpecification;

public class PersistAnnotationWorker
implements MethodAnnotationEnhancementWorker {
    public static final String DEFAULT_PROPERTY_PERSISTENCE_STRATEGY = "org.apache.tapestry.default-property-persistence-strategy";
    private IPropertySource _propertySource;

    public void performEnhancement(EnhancementOperation op, IComponentSpecification spec, Method method, Location location) {
        Persist p = method.getAnnotation(Persist.class);
        InitialValue iv = method.getAnnotation(InitialValue.class);
        String propertyName = AnnotationUtils.getPropertyName(method);
        String defaultStrategy = this._propertySource.getPropertyValue(DEFAULT_PROPERTY_PERSISTENCE_STRATEGY);
        String stategy = p.value().length() == 0 ? defaultStrategy : p.value();
        PropertySpecification pspec = new PropertySpecification();
        pspec.setName(propertyName);
        pspec.setPersistence(stategy);
        pspec.setLocation(location);
        pspec.setInitialValue(iv == null ? null : iv.value());
        spec.addPropertySpecification((IPropertySpecification)pspec);
    }

    public void setPropertySource(IPropertySource propertySource) {
        this._propertySource = propertySource;
    }
}

