/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.contrib.tree.components;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IBinding;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.contrib.tree.model.ISessionStoreManager;
import org.apache.tapestry.contrib.tree.model.ITreeModel;
import org.apache.tapestry.contrib.tree.model.ITreeModelSource;
import org.apache.tapestry.contrib.tree.model.ITreeSessionStateManager;
import org.apache.tapestry.contrib.tree.model.ITreeStateListener;
import org.apache.tapestry.contrib.tree.simple.FullTreeSessionStateManager;
import org.apache.tapestry.event.PageBeginRenderListener;
import org.apache.tapestry.event.PageDetachListener;
import org.apache.tapestry.event.PageEvent;
import org.apache.tapestry.util.ComponentAddress;

public abstract class TreeView
extends BaseComponent
implements PageDetachListener,
PageBeginRenderListener,
ITreeModelSource {
    private static final Log LOG = LogFactory.getLog((Class)TreeView.class);
    private IBinding m_objSessionStoreManagerBinding;
    private IBinding m_objTreeModelBinding;
    private IBinding m_objSessionStateManagerBinding;
    private ITreeModel m_objTreeModel;
    private ITreeSessionStateManager m_objTreeSessionStateManager;
    private ISessionStoreManager m_objSessionStoreManager;
    private Object m_objTreeSessionState;
    private ComponentAddress m_objComponentAddress;

    public TreeView() {
        this.initialize();
    }

    private void initialize() {
        this.m_objTreeModel = null;
        this.m_objTreeSessionStateManager = null;
        this.m_objSessionStoreManager = null;
        this.m_objTreeSessionState = null;
        this.m_objComponentAddress = null;
    }

    public void pageDetached(PageEvent arg0) {
        this.initialize();
    }

    public void pageBeginRender(PageEvent arg0) {
        if (arg0.getRequestCycle().isRewinding()) {
            return;
        }
        this.storeSesion();
    }

    public IBinding getTreeModelBinding() {
        return this.m_objTreeModelBinding;
    }

    public void setTreeModelBinding(IBinding treeModelBinding) {
        this.m_objTreeModelBinding = treeModelBinding;
    }

    public IBinding getSessionStoreManagerBinding() {
        return this.m_objSessionStoreManagerBinding;
    }

    public IBinding getSessionStateManagerBinding() {
        return this.m_objSessionStateManagerBinding;
    }

    public void setSessionStoreManagerBinding(IBinding sessionStoreManagerBinding) {
        this.m_objSessionStoreManagerBinding = sessionStoreManagerBinding;
    }

    public void setSessionStateManagerBinding(IBinding sessionStateManagerBinding) {
        this.m_objSessionStateManagerBinding = sessionStateManagerBinding;
    }

    private void extractTreeModel() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"TreeView.extractTreeModel()");
        }
        ISessionStoreManager objHolder = this.getSessionStoreManager();
        ITreeSessionStateManager objSessionManager = this.getTreeSessionStateMgr();
        Object objSessionState = objHolder == null ? this.getTreeSessionState() : objHolder.getSessionState(this.getPage(), "treeSessionState");
        if (objSessionState != null) {
            this.m_objTreeModel = objSessionManager.getModel(objSessionState);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"TreeView.extractTreeModel() from BINDING");
            }
            this.m_objTreeModel = (ITreeModel)this.getTreeModelBinding().getObject();
        }
    }

    private void storeSesion() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"TreeView.storeSesion()");
        }
        ITreeSessionStateManager objSessionManager = this.getTreeSessionStateMgr();
        Object objSessionState = objSessionManager.getSessionState(this.getTreeModel());
        this.store(objSessionState);
    }

    private void store(Object objSessionState) {
        ISessionStoreManager objHolder = this.getSessionStoreManager();
        if (objHolder == null) {
            Tapestry.fireObservedChange((IComponent)this, (String)"treeSessionState", (Object)objSessionState);
        } else {
            String strPath = this.getExtendedId();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("store(): setting state with: " + strPath));
            }
            objHolder.setSessionState(this.getPage(), strPath, objSessionState);
        }
    }

    public void resetState() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"TreeView.resetState()");
        }
        this.initialize();
        this.store(null);
    }

    public ISessionStoreManager getSessionStoreManager() {
        if (this.m_objSessionStoreManager == null && this.getSessionStoreManagerBinding() != null) {
            this.m_objSessionStoreManager = (ISessionStoreManager)this.getSessionStoreManagerBinding().getObject();
        }
        return this.m_objSessionStoreManager;
    }

    public ITreeSessionStateManager getTreeSessionStateMgr() {
        if (this.m_objTreeSessionStateManager == null) {
            IBinding objBinding = this.getSessionStateManagerBinding();
            if (objBinding != null) {
                Object objManager = objBinding.getObject();
                this.m_objTreeSessionStateManager = (ITreeSessionStateManager)objManager;
            } else {
                this.m_objTreeSessionStateManager = new FullTreeSessionStateManager();
            }
        }
        return this.m_objTreeSessionStateManager;
    }

    public ComponentAddress getComponentPath() {
        if (this.m_objComponentAddress == null) {
            this.m_objComponentAddress = new ComponentAddress((IComponent)this);
        }
        return this.m_objComponentAddress;
    }

    public ITreeModel getTreeModel() {
        if (this.m_objTreeModel == null) {
            this.extractTreeModel();
        }
        return this.m_objTreeModel;
    }

    public void setTreeModel(ITreeModel treeModel) {
        this.m_objTreeModel = treeModel;
    }

    public Object getTreeSessionState() {
        return this.m_objTreeSessionState;
    }

    public void setTreeSessionState(Object treeSessionState) {
        this.m_objTreeSessionState = treeSessionState;
    }

    public String getSelectedNodeStyleID() {
        return this.getId() + ":selected";
    }

    protected void renderComponent(IMarkupWriter arg0, IRequestCycle arg1) {
        Object objExistedTreeModelSource = arg1.getAttribute("org.apache.tapestry.contrib.tree.model.ITreeModelSource");
        arg1.setAttribute("org.apache.tapestry.contrib.tree.model.ITreeModelSource", (Object)this);
        super.renderComponent(arg0, arg1);
        arg1.setAttribute("org.apache.tapestry.contrib.tree.model.ITreeModelSource", objExistedTreeModelSource);
    }

    public ITreeStateListener getTreeStateListener() {
        ITreeStateListener objListener = null;
        IBinding objBinding = this.getBinding("treeStateListener");
        if (objBinding != null) {
            objListener = (ITreeStateListener)objBinding.getObject();
        }
        return objListener;
    }
}

