/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.portlet;

import javax.portlet.PortletConfig;
import org.apache.hivemind.Resource;
import org.apache.tapestry.parse.ISpecificationParser;
import org.apache.tapestry.portlet.PortletApplicationInitializer;
import org.apache.tapestry.services.ApplicationGlobals;
import org.apache.tapestry.spec.ApplicationSpecification;
import org.apache.tapestry.spec.IApplicationSpecification;
import org.apache.tapestry.web.WebContext;
import org.apache.tapestry.web.WebContextResource;

public class PortletApplicationSpecificationInitializer
implements PortletApplicationInitializer {
    private WebContext _context;
    private ApplicationGlobals _globals;
    private ISpecificationParser _parser;

    public void initialize(PortletConfig portletConfig) {
        String name = portletConfig.getPortletName();
        Resource resource = this.findApplicationSpecification(name);
        IApplicationSpecification specification = resource == null ? this.constructStandinSpecification(name) : this._parser.parseApplicationSpecification(resource);
        this._globals.storeSpecification(specification);
    }

    private Resource findApplicationSpecification(String name) {
        String expectedName = name + ".application";
        WebContextResource webInfLocation = new WebContextResource(this._context, "/WEB-INF/");
        Resource webInfAppLocation = webInfLocation.getRelativeResource(name + "/");
        Resource result = this.check(webInfAppLocation, expectedName);
        if (result != null) {
            return result;
        }
        return this.check((Resource)webInfLocation, expectedName);
    }

    private Resource check(Resource resource, String name) {
        Resource result = resource.getRelativeResource(name);
        if (result.getResourceURL() != null) {
            return result;
        }
        return null;
    }

    private IApplicationSpecification constructStandinSpecification(String name) {
        ApplicationSpecification result = new ApplicationSpecification();
        WebContextResource virtualLocation = new WebContextResource(this._context, "/WEB-INF/" + name + ".application");
        result.setSpecificationLocation((Resource)virtualLocation);
        result.setName(name);
        return result;
    }

    public void setContext(WebContext context) {
        this._context = context;
    }

    public void setGlobals(ApplicationGlobals globals) {
        this._globals = globals;
    }

    public void setParser(ISpecificationParser parser) {
        this._parser = parser;
    }
}

