/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.portlet.bindings;

import java.util.Map;
import javax.portlet.PortletRequest;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.Location;
import org.apache.hivemind.util.Defense;
import org.apache.tapestry.binding.AbstractBinding;
import org.apache.tapestry.coerce.ValueConverter;
import org.apache.tapestry.portlet.bindings.BindingsMessages;

public class UserAttributeBinding
extends AbstractBinding {
    private final PortletRequest _request;
    private final String _attributeName;

    public UserAttributeBinding(String description, ValueConverter valueConverter, Location location, PortletRequest request, String attributeName) {
        super(description, valueConverter, location);
        Defense.notNull((Object)request, (String)"request");
        Defense.notNull((Object)attributeName, (String)"attributeName");
        this._request = request;
        this._attributeName = attributeName;
    }

    public boolean isInvariant() {
        return false;
    }

    private Map getUserInfo() {
        Map result = (Map)this._request.getAttribute("javax.portlet.userinfo");
        if (result == null) {
            throw new ApplicationRuntimeException(BindingsMessages.noUserInfo(), this.getLocation(), null);
        }
        return result;
    }

    public Object getObject() {
        return this.getUserInfo().get(this._attributeName);
    }

    public void setObject(Object value) {
        String asString = (String)this.getValueConverter().coerceValue(value, String.class);
        this.getUserInfo().put(this._attributeName, asString);
    }
}

