/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.precision;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateFilter;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.precision.CommonBits;

public class CommonBitsRemover {
    private Coordinate commonCoord;
    private CommonCoordinateFilter ccFilter = new CommonCoordinateFilter();

    public void add(Geometry geom) {
        geom.apply(this.ccFilter);
        this.commonCoord = this.ccFilter.getCommonCoordinate();
    }

    public Coordinate getCommonCoordinate() {
        return this.commonCoord;
    }

    public Geometry removeCommonBits(Geometry geom) {
        if (this.commonCoord.x == 0.0 && this.commonCoord.y == 0.0) {
            return geom;
        }
        Coordinate invCoord = new Coordinate(this.commonCoord);
        invCoord.x = -invCoord.x;
        invCoord.y = -invCoord.y;
        Translater trans = new Translater(invCoord);
        geom.apply(trans);
        geom.geometryChanged();
        return geom;
    }

    public void addCommonBits(Geometry geom) {
        Translater trans = new Translater(this.commonCoord);
        geom.apply(trans);
        geom.geometryChanged();
    }

    class Translater
    implements CoordinateSequenceFilter {
        Coordinate trans = null;

        public Translater(Coordinate trans) {
            this.trans = trans;
        }

        @Override
        public void filter(CoordinateSequence seq, int i) {
            double xp = seq.getOrdinate(i, 0) + this.trans.x;
            double yp = seq.getOrdinate(i, 1) + this.trans.y;
            seq.setOrdinate(i, 0, xp);
            seq.setOrdinate(i, 1, yp);
        }

        @Override
        public boolean isDone() {
            return false;
        }

        @Override
        public boolean isGeometryChanged() {
            return true;
        }
    }

    class CommonCoordinateFilter
    implements CoordinateFilter {
        private CommonBits commonBitsX = new CommonBits();
        private CommonBits commonBitsY = new CommonBits();

        CommonCoordinateFilter() {
        }

        @Override
        public void filter(Coordinate coord) {
            this.commonBitsX.add(coord.x);
            this.commonBitsY.add(coord.y);
        }

        public Coordinate getCommonCoordinate() {
            return new Coordinate(this.commonBitsX.getCommon(), this.commonBitsY.getCommon());
        }
    }
}

