/*
 * Decompiled with CFR 0.152.
 */
package org.datasyslab.geospark.formatMapper;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.io.WKTReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.datasyslab.geospark.enums.FileDataSplitter;
import org.datasyslab.geospark.formatMapper.FormatMapper;
import org.wololo.geojson.Feature;
import org.wololo.geojson.GeoJSONFactory;
import org.wololo.jts2geojson.GeoJSONReader;

public class PolygonFormatMapper
extends FormatMapper
implements FlatMapFunction<Iterator<String>, Object> {
    public PolygonFormatMapper(FileDataSplitter Splitter, boolean carryInputData) {
        super(Splitter, carryInputData);
    }

    public PolygonFormatMapper(Integer startOffset, Integer endOffset, FileDataSplitter Splitter, boolean carryInputData) {
        super(startOffset, endOffset, Splitter, carryInputData);
    }

    public List<Object> call(Iterator<String> stringIterator) throws Exception {
        MultiPolygon multiSpatialObjects = null;
        ArrayList<Object> result = new ArrayList<Object>();
        block8: while (stringIterator.hasNext()) {
            String line = stringIterator.next();
            try {
                switch (this.splitter) {
                    case CSV: {
                        this.lineSplitList = Arrays.asList(line.split(this.splitter.getDelimiter()));
                        this.coordinatesList = new ArrayList();
                        int actualEndOffset = this.endOffset >= 0 ? this.endOffset : this.lineSplitList.size() - 1;
                        for (int i = this.startOffset.intValue(); i <= actualEndOffset; i += 2) {
                            this.coordinatesList.add(new Coordinate(Double.parseDouble((String)this.lineSplitList.get(i)), Double.parseDouble((String)this.lineSplitList.get(i + 1))));
                        }
                        LinearRing linear = this.fact.createLinearRing(this.coordinatesList.toArray(new Coordinate[this.coordinatesList.size()]));
                        this.spatialObject = new Polygon(linear, null, this.fact);
                        if (this.carryInputData) {
                            this.spatialObject.setUserData(line);
                        }
                        result.add((Polygon)this.spatialObject);
                        break;
                    }
                    case TSV: {
                        this.lineSplitList = Arrays.asList(line.split(this.splitter.getDelimiter()));
                        this.coordinatesList = new ArrayList();
                        int actualEndOffset = this.endOffset >= 0 ? this.endOffset : this.lineSplitList.size() - 1;
                        for (int i = this.startOffset.intValue(); i <= actualEndOffset; i += 2) {
                            this.coordinatesList.add(new Coordinate(Double.parseDouble((String)this.lineSplitList.get(i)), Double.parseDouble((String)this.lineSplitList.get(i + 1))));
                        }
                        this.coordinates = new Coordinate[this.coordinatesList.size()];
                        this.coordinates = this.coordinatesList.toArray(this.coordinates);
                        LinearRing linear = this.fact.createLinearRing(this.coordinates);
                        this.spatialObject = new Polygon(linear, null, this.fact);
                        if (this.carryInputData) {
                            this.spatialObject.setUserData(line);
                        }
                        result.add((Polygon)this.spatialObject);
                        break;
                    }
                    case GEOJSON: {
                        GeoJSONReader reader = new GeoJSONReader();
                        if (line.contains("Feature")) {
                            Feature feature = (Feature)GeoJSONFactory.create(line);
                            this.spatialObject = reader.read(feature.getGeometry());
                        } else {
                            this.spatialObject = reader.read(line);
                        }
                        if (this.spatialObject instanceof MultiPolygon) {
                            multiSpatialObjects = (MultiPolygon)this.spatialObject;
                            for (int i = 0; i < multiSpatialObjects.getNumGeometries(); ++i) {
                                this.spatialObject = multiSpatialObjects.getGeometryN(i);
                                if (this.carryInputData) {
                                    this.spatialObject.setUserData(line);
                                }
                                result.add((Polygon)this.spatialObject);
                            }
                            continue block8;
                        }
                        if (this.carryInputData) {
                            this.spatialObject.setUserData(line);
                        }
                        result.add((Polygon)this.spatialObject);
                        break;
                    }
                    case WKT: {
                        this.lineSplitList = Arrays.asList(line.split(this.splitter.getDelimiter()));
                        WKTReader wktreader = new WKTReader();
                        this.spatialObject = wktreader.read((String)this.lineSplitList.get(this.startOffset));
                        if (this.spatialObject instanceof MultiPolygon) {
                            multiSpatialObjects = (MultiPolygon)this.spatialObject;
                            for (int i = 0; i < multiSpatialObjects.getNumGeometries(); ++i) {
                                this.spatialObject = multiSpatialObjects.getGeometryN(i);
                                if (this.carryInputData) {
                                    this.spatialObject.setUserData(line);
                                }
                                result.add((Polygon)this.spatialObject);
                            }
                            continue block8;
                        }
                        if (this.carryInputData) {
                            this.spatialObject.setUserData(line);
                        }
                        result.add((Polygon)this.spatialObject);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }
}

