/*
 * Decompiled with CFR 0.152.
 */
package org.datasyslab.geospark.joinJudgement;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.index.SpatialIndex;
import com.vividsolutions.jts.index.quadtree.Quadtree;
import com.vividsolutions.jts.index.strtree.STRtree;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.spark.api.java.function.FlatMapFunction2;
import org.datasyslab.geospark.geometryObjects.Circle;
import org.datasyslab.geospark.geometryObjects.PairGeometry;

public class GeometryByCircleJudgementUsingIndex
implements FlatMapFunction2<Iterator<SpatialIndex>, Iterator<Object>, PairGeometry>,
Serializable {
    boolean considerBoundaryIntersection = false;

    public GeometryByCircleJudgementUsingIndex(boolean considerBoundaryIntersection) {
        this.considerBoundaryIntersection = considerBoundaryIntersection;
    }

    public List<PairGeometry> call(Iterator<SpatialIndex> iteratorTree, Iterator<Object> iteratorWindow) throws Exception {
        ArrayList<PairGeometry> result = new ArrayList<PairGeometry>();
        if (!iteratorTree.hasNext()) {
            return result;
        }
        SpatialIndex treeIndex = iteratorTree.next();
        treeIndex = treeIndex instanceof STRtree ? (STRtree)treeIndex : (Quadtree)treeIndex;
        while (iteratorWindow.hasNext()) {
            Circle window = (Circle)iteratorWindow.next();
            List queryResult = new ArrayList();
            queryResult = treeIndex.query(window.getEnvelopeInternal());
            if (queryResult.size() == 0) continue;
            HashSet<Geometry> objectHashSet = new HashSet<Geometry>();
            for (Geometry spatialObject : queryResult) {
                if (this.considerBoundaryIntersection) {
                    if (!window.intersects(spatialObject)) continue;
                    objectHashSet.add(spatialObject);
                    continue;
                }
                if (!window.covers(spatialObject)) continue;
                objectHashSet.add(spatialObject);
            }
            if (objectHashSet.size() == 0) continue;
            result.add(new PairGeometry(window, objectHashSet));
        }
        return result;
    }
}

