/*
 * Decompiled with CFR 0.152.
 */
package org.datasyslab.geospark.spatialPartitioning;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.index.strtree.STRtree;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class RtreePartitioning
implements Serializable {
    List<Envelope> grids = new ArrayList<Envelope>();

    public RtreePartitioning(List SampleList, Envelope boundary, int partitions) throws Exception {
        STRtree strtree = new STRtree(SampleList.size() / partitions);
        for (int i = 0; i < SampleList.size(); ++i) {
            Comparable spatialObject;
            if (SampleList.get(i) instanceof Envelope) {
                spatialObject = (Envelope)SampleList.get(i);
                strtree.insert((Envelope)spatialObject, (Object)spatialObject);
                continue;
            }
            if (SampleList.get(i) instanceof Geometry) {
                spatialObject = (Geometry)SampleList.get(i);
                strtree.insert(((Geometry)spatialObject).getEnvelopeInternal(), (Object)spatialObject);
                continue;
            }
            throw new Exception("[RtreePartitioning][Constrcutor] Unsupported spatial object type");
        }
        List envelopes = strtree.queryBoundary();
        for (int i = 0; i < envelopes.size(); ++i) {
            this.grids.add((Envelope)envelopes.get(i));
        }
    }

    public List<Envelope> getGrids() {
        return this.grids;
    }
}

