/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.noding;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateArrays;
import com.vividsolutions.jts.noding.NodedSegmentString;
import com.vividsolutions.jts.noding.Noder;
import com.vividsolutions.jts.noding.SegmentString;
import com.vividsolutions.jts.util.CollectionUtil;
import java.util.Collection;

public class ScaledNoder
implements Noder {
    private Noder noder;
    private double scaleFactor;
    private double offsetX;
    private double offsetY;
    private boolean isScaled = false;

    public ScaledNoder(Noder noder, double scaleFactor) {
        this(noder, scaleFactor, 0.0, 0.0);
    }

    public ScaledNoder(Noder noder, double scaleFactor, double offsetX, double offsetY) {
        this.noder = noder;
        this.scaleFactor = scaleFactor;
        this.isScaled = !this.isIntegerPrecision();
    }

    public boolean isIntegerPrecision() {
        return this.scaleFactor == 1.0;
    }

    @Override
    public Collection getNodedSubstrings() {
        Collection splitSS = this.noder.getNodedSubstrings();
        if (this.isScaled) {
            this.rescale(splitSS);
        }
        return splitSS;
    }

    @Override
    public void computeNodes(Collection inputSegStrings) {
        Collection intSegStrings = inputSegStrings;
        if (this.isScaled) {
            intSegStrings = this.scale(inputSegStrings);
        }
        this.noder.computeNodes(intSegStrings);
    }

    private Collection scale(Collection segStrings) {
        return CollectionUtil.transform(segStrings, new CollectionUtil.Function(){

            @Override
            public Object execute(Object obj) {
                SegmentString ss = (SegmentString)obj;
                return new NodedSegmentString(ScaledNoder.this.scale(ss.getCoordinates()), ss.getData());
            }
        });
    }

    private Coordinate[] scale(Coordinate[] pts) {
        Coordinate[] roundPts = new Coordinate[pts.length];
        for (int i = 0; i < pts.length; ++i) {
            roundPts[i] = new Coordinate(Math.round((pts[i].x - this.offsetX) * this.scaleFactor), Math.round((pts[i].y - this.offsetY) * this.scaleFactor), pts[i].z);
        }
        Coordinate[] roundPtsNoDup = CoordinateArrays.removeRepeatedPoints(roundPts);
        return roundPtsNoDup;
    }

    private void rescale(Collection segStrings) {
        CollectionUtil.apply(segStrings, new CollectionUtil.Function(){

            @Override
            public Object execute(Object obj) {
                SegmentString ss = (SegmentString)obj;
                ScaledNoder.this.rescale(ss.getCoordinates());
                return null;
            }
        });
    }

    private void rescale(Coordinate[] pts) {
        Coordinate p0 = null;
        Coordinate p1 = null;
        if (pts.length == 2) {
            p0 = new Coordinate(pts[0]);
            p1 = new Coordinate(pts[1]);
        }
        for (int i = 0; i < pts.length; ++i) {
            pts[i].x = pts[i].x / this.scaleFactor + this.offsetX;
            pts[i].y = pts[i].y / this.scaleFactor + this.offsetY;
        }
        if (pts.length == 2 && pts[0].equals2D(pts[1])) {
            System.out.println(pts);
        }
    }
}

