/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.simplify;

import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryComponentFilter;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.util.GeometryTransformer;
import com.vividsolutions.jts.simplify.TaggedLineString;
import com.vividsolutions.jts.simplify.TaggedLinesSimplifier;
import java.util.HashMap;
import java.util.Map;

public class TopologyPreservingSimplifier {
    private Geometry inputGeom;
    private TaggedLinesSimplifier lineSimplifier = new TaggedLinesSimplifier();
    private Map linestringMap;

    public static Geometry simplify(Geometry geom, double distanceTolerance) {
        TopologyPreservingSimplifier tss = new TopologyPreservingSimplifier(geom);
        tss.setDistanceTolerance(distanceTolerance);
        return tss.getResultGeometry();
    }

    public TopologyPreservingSimplifier(Geometry inputGeom) {
        this.inputGeom = inputGeom;
    }

    public void setDistanceTolerance(double distanceTolerance) {
        if (distanceTolerance < 0.0) {
            throw new IllegalArgumentException("Tolerance must be non-negative");
        }
        this.lineSimplifier.setDistanceTolerance(distanceTolerance);
    }

    public Geometry getResultGeometry() {
        if (this.inputGeom.isEmpty()) {
            return (Geometry)this.inputGeom.clone();
        }
        this.linestringMap = new HashMap();
        this.inputGeom.apply(new LineStringMapBuilderFilter());
        this.lineSimplifier.simplify(this.linestringMap.values());
        Geometry result = new LineStringTransformer().transform(this.inputGeom);
        return result;
    }

    class LineStringMapBuilderFilter
    implements GeometryComponentFilter {
        LineStringMapBuilderFilter() {
        }

        @Override
        public void filter(Geometry geom) {
            if (geom instanceof LineString) {
                LineString line = (LineString)geom;
                if (line.isEmpty()) {
                    return;
                }
                int minSize = line.isClosed() ? 4 : 2;
                TaggedLineString taggedLine = new TaggedLineString(line, minSize);
                TopologyPreservingSimplifier.this.linestringMap.put(line, taggedLine);
            }
        }
    }

    class LineStringTransformer
    extends GeometryTransformer {
        LineStringTransformer() {
        }

        @Override
        protected CoordinateSequence transformCoordinates(CoordinateSequence coords, Geometry parent) {
            if (coords.size() == 0) {
                return null;
            }
            if (parent instanceof LineString) {
                TaggedLineString taggedLine = (TaggedLineString)TopologyPreservingSimplifier.this.linestringMap.get(parent);
                return this.createCoordinateSequence(taggedLine.getResultCoordinates());
            }
            return super.transformCoordinates(coords, parent);
        }
    }
}

